<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : Visitor (VisitorController)
 * Visitor Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 30 August 2019
 */
class CronJobs extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
//$this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  function shiftStart() {

    $allShifts = getAllShiftMngtToStart();
    // pre($allShifts);
    foreach ($allShifts as $shiftMngt) {
      $allTeamMembers = $this->supervisorPresentTeam($shiftMngt);
    //  pre($allTeamMembers);
      foreach ($allTeamMembers as $team_employee) {
        if (is_object($team_employee)) {
          $insert_data = array(
            'user_id' => $team_employee->user_id,
            'superviser_id' => $shiftMngt['superviser_id'],
            'org_id' => $shiftMngt['org_id'],
            'client_id' => $shiftMngt['client_id'],
            'dept_id' => $shiftMngt['dept_id'],
            'sub_dept_id' => $shiftMngt['sub_dept_id'],
            'shift_id' => $shiftMngt['shift'],
            'check_in' => date("Y-m-d H:i:s"),
            'status' => '1',
          );
          $this->db->insert('working_logs', $insert_data);
        //   echo last_query();
        }
      }
    }
//    $this->shiftFinish();
  }

  function shiftFinish() {
    $allShifts = getAllShiftMngtToFinish();
    foreach ($allShifts as $shiftMngt) {
//      $allTeamMembers = $this->supervisorPresentTeam($shiftMngt['superviser_id']);
////      pre($allTeamMembers);
//      foreach ($allTeamMembers as $team_employee) {
//        if (is_object($team_employee)) {

      $update_data_log = array(
        'check_out' => date("Y-m-d H:i:s"),
//              'status' => '0',
        'status' => "'status' => 'CASE WHEN status = '1' THEN 2 WHEN status = '3' THEN 4 END',",
      );

      $this->db->set('status', "CASE "
          . "WHEN status = '1' THEN '2' "
          . "WHEN status = '3' THEN '4'  "
          . " ELSE working_logs.status"
          . " END", FALSE);
      $this->db->set('check_out', date("Y-m-d H:i:s"));
      $where = array(
//              'user_id' => $team_employee->user_id,
        'superviser_id' => $shiftMngt['superviser_id'],
//              'dept_id' => $shiftMngt['dept_id'],
//              'sub_dept_id' => $shiftMngt['sub_dept_id'],
        'shift_id' => $shiftMngt['shift'],
//              'status' => '1',
      );
      $this->db->like('check_in', date('Y-m-d'), 'after');
      $this->db->where($where);
      $this->db->where_in('status', ['1', '3']);
//          pre($update_data_log);
      $this->db->update('working_logs');
//          $this->db->update('working_logs', $update_data_log);
//      last_query();
//        }
//      }
    }
  }

  function supervisorPresentTeam($mngtArray) {
    // pre($mngtArray);
//    echo $superVisorId;
//    $mngtArray = getShiftMngtBySupervisor($superVisorId);
//    pre($mngtArray);
    $departmentId = $mngtArray['dept_id'];
    $subDepartmentId = $mngtArray['sub_dept_id'];
    $clientId = $mngtArray['client_id'];
    $orgId = $mngtArray['org_id'];
    $shiftId = $mngtArray['shift'];
    echo $selectQuery = 'SELECT '
        . '  '
        . 'U.roleId AS user_role,'
        . 'U.designation, '
        . 'U.userId AS user_id, '
        . 'U.name AS employee_name, '
        . 'U.email AS employee_email, '
        . 'U.emp_id AS employee_id, '
        . 'U.emp_code AS employee_code,'
        . 'U.department_id, U.current_status, '
        . '(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
        . '(SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name FROM tbl_users AS U '
        . 'WHERE  U.shift = ' . $shiftId . '  and organization_id = ' . $orgId . ' AND  U.userId != ' . $mngtArray['superviser_id'] . ' AND U.current_status != 0 AND U.client_id = ' . $clientId . '  AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' and U.roleId  = 3';
        // die;
    return $all_team_employees = $this->db->query($selectQuery)->result();
//return $data = $CI->db->get('tbl_sub_departments')->row();
  }

  function notUsingWhReport() {
    $date = date('Y-m-d', strtotime("-1 days"));

    $this->db->select(
        'tbl_organization.org_name,'
        . 'tbl_organization.id as orgId,'
        . 'tbl_organization.loc_id,'
        . 'tbl_sub_dept_mngt.client_id,'
        . 'tbl_users.name,tbl_clients.client,'
        . 'tbl_sub_dept_mngt.id,'
        . 'tbl_sub_departments.sub_dept_name,'
        . 'tbl_shift.shift_name,'
        . 'shift_mgmt.in_time,'
        . 'shift_mgmt.out_time,'
        . 'shift_mgmt.shift,'
        . 'tbl_departments.dept_name,'
        . 'tbl_organization.client_id as clientIds,'
        . 'tbl_users.userId as supervisorId,'
        . 'tbl_sub_dept_mngt.banchmark,'
        . 'tbl_users.userId,'
        . 'tbl_users.userId,'
        . 'tbl_users.userId,'
        . 'tbl_users.createdBy'
    );
    $this->db->from('tbl_sub_dept_mngt');
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    $this->db->where('tbl_sub_dept_mngt.isDeleted', '0');
//    $this->db->group_by('tbl_users.userId');
    $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_sub_dept_mngt.dept_id', 'left');
    $this->db->join('tbl_sub_departments', 'tbl_sub_departments.id = tbl_sub_dept_mngt.sub_dept_id', 'left');
    $this->db->join('shift_mgmt', 'shift_mgmt.id = tbl_sub_dept_mngt.shift_mngt_id', 'left');
    $this->db->join('tbl_users', 'tbl_users.userId = shift_mgmt.superviser_id', 'Right');
    $this->db->join('tbl_organization', 'tbl_organization.id = tbl_sub_dept_mngt.org_id', 'left');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $this->db->join('tbl_clients', 'tbl_clients.id = tbl_sub_dept_mngt.client_id', 'left');
    $this->db->group_by('loc_id,orgId,client_id,shift');
    $query = $this->db->get();
    $results = $query->result_array();
    $allData = [];
    foreach ($results as $result) {
//      pre($result);
      $isUploaded = $this->getPerformanceData($result);
      if ($isUploaded === 'false') {
        $allData[] = $result;
      }
    }



    // $to = "vijayraj.ch@seabird.co.in,praveen.t@seabird.co.in,karunesh.t@seabird.co.in,functional.sll@seabird.co.in,anish.p@seabird.co.in";
    $to = "prashant.c@seabird.co.in";
    $subject = "EEMS REPORT - Productivity Not Uploaded list (" . $date . ")";
    $message = '
<html>
<head>
<title>HTML email</title>
</head>
<body>';
    $message .= '<p>EEMS Tracking Report  (' . $date . ')  </p>';
    $message .= '<p>Total Count  (' . count($allData) . ')  </p>';

    $message .= '<table border="0" cellpadding="0" cellspacing="0" width="332" style="border-collapse:collapse;width:250pt">

 <colgroup><col width="62" style="width:47pt">
 <col width="86" style="width:65pt">
 <col width="49" style="width:37pt">
 <col width="84" style="width:63pt">
 <col width="51" style="width:38pt">
 </colgroup><tbody><tr height="20" style="height:15pt">
  <td height="20" width="62" style="height:15pt;width:47pt;border:0.5pt solid windowtext;background:rgb(180,198,231);padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">LOCATION</td>
  <td width="86" style="border-left:none;width:65pt;border-top:0.5pt solid windowtext;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;background:rgb(180,198,231);padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">WAREHOUSE</td>
  <td width="49" style="border-left:none;width:37pt;border-top:0.5pt solid windowtext;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;background:rgb(180,198,231);padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">SUPERVISOR</td>
  <td width="49" style="border-left:none;width:37pt;border-top:0.5pt solid windowtext;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;background:rgb(180,198,231);padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">CLIENT</td>
  <td width="49" style="border-left:none;width:37pt;border-top:0.5pt solid windowtext;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;background:rgb(180,198,231);padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">DEPARTMENT</td>
  <td width="49" style="border-left:none;width:37pt;border-top:0.5pt solid windowtext;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;background:rgb(180,198,231);padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">SUB DEPARTMENT</td>
  <td width="84" style="border-left:none;width:63pt;border-top:0.5pt solid windowtext;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;background:rgb(180,198,231);padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">SHIFT (TIME)</td>
  <td width="51" style="border-left:none;width:38pt;border-top:0.5pt solid windowtext;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;background:rgb(180,198,231);padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">ADMIN</td>
 </tr>';
//    die;

    foreach ($allData as $result) {
//      $isUploaded = $this->getPerformanceData($result);
//      if ($isUploaded === 'false') {
//        $allData[] = $result;
      $adminInfo = $this->user_model->getUserInfo($result['createdBy']);
      $message .= '<tr height="20" style="height:15pt">
  <td height="20" style="height:15pt;border-top:none;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;border-left:0.5pt solid windowtext;padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">' . locationName($result['loc_id']) . '</td>
  <td style="border-top:none;border-left:none;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">' . orgName($result['orgId']) . '</td>
  <td style="border-top:none;border-left:none;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">' . empNameById($result['supervisorId']) . '</td>
  <td style="border-top:none;border-left:none;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">' . clientName($result['client_id']) . '</td>
  <td style="border-top:none;border-left:none;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">' . $result['dept_name'] . '</td>
  <td style="border-top:none;border-left:none;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">' . $result['sub_dept_name'] . '</td>
  <td style="border-top:none;border-left:none;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">' . $result['shift_name'] . ' ( ' . $result['in_time'] . ' to ' . $result['out_time'] . '</td>
  <td style="border-top:none;border-left:none;border-right:0.5pt solid windowtext;border-bottom:0.5pt solid windowtext;padding-top:1px;padding-right:1px;padding-left:1px;color:black;font-size:11pt;font-family:Calibri;vertical-align:bottom;white-space:nowrap">' . $adminInfo->name . ' (' . $adminInfo->mobile . ') </td></tr>';
//      }
    }
    $message .= '</body>
      </html>

      <br>
      <br>
      <br>
      <br>
      Thanks & Regards<br>
      EEMS Tracking Team..
      ';
// Always set content-type when sending HTML email
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

// More headers

//  $headers .='From:  Birthday Wish <birthday@seabirdlogisolutions.com>'. "\r\n";
 
    $headers .= 'From: EEMS Tracking Team <support@seabirdlogisolutions.com>' . "\r\n";
   // $headers .= 'Cc: vikas.s@seabird.co.in,karunesh.t@seabird.co.in,sudhir.t@seabird.co.in,divya.k@seabird.co.in' . "\r\n";
//$headers .= 'Cc: myboss@example.com' . "\r\n";
    echo $message;
//    die;
//die;
   // echo mail($to, $subject, $message, $headers);
    die;
  }

  function getPerformanceData($data) {
    $employee_performance_data_query = $this->db->select(array('*'))->from('tbl_manpower_team_performance')
//            ->where('employee_id', $employee->employee_id)
            ->where('org', $data['orgId'])
            ->where('client', $data['client_id'])
            ->where('absent', '0')
            ->where('shift', $data['shift_name'])
            ->where('date', date('Y-m-d', strtotime("-1 days")))->group_by('org,client,shift')->get();
//    last_query();
    if ($employee_performance_data_query->num_rows()) {

      return 'true';
    } else {
      return 'false';
    }
  }

  function notActiveDeptSubDept() {

    $selectQuery = 'SELECT '
        . '  '
        . 'U.roleId AS user_role,'
        . 'U.designation, '
        . 'U.userId AS user_id, '
        . 'U.name AS employee_name, '
        . 'U.email AS employee_email, '
        . 'U.emp_id AS employee_id, '
        . 'U.emp_code AS employee_code,'
        . 'U.department_id, U.current_status, '
        . '(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
        . '(SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name FROM tbl_users AS U '
        . 'WHERE U.userId != ' . $mngtArray['superviser_id'] . ' AND U.current_status != 0 AND U.client_id = ' . $clientId . '  AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' and U. 	roleId  = 3';
    return $all_team_employees = $this->db->query($selectQuery)->result();
//return $data = $CI->db->get('tbl_sub_departments')->row();
  }

}
