<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : Visitor (VisitorController)
 * Visitor Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 30 August 2019
 */
class ManpowerController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  public function index() {
    $this->global['pageTitle'] = 'Searbird : Manpower';
    $this->loadViews("manpower_view", $this->global, $data, NULL);
  }

  function manpowerReport() {
    $this->global['pageTitle'] = 'Searbird : Manpower Report';
    $this->loadViews("manpower_report_view", $this->global, $data, NULL);
  }

  function list_teams() {

    $data['all_teams'] = $this->db->query('SELECT MT.id AS id, (SELECT COUNT(id) FROM tbl_manpower_team_performance WHERE team_id=MT.id) AS performance_already_exists, MT.date AS date, (SELECT dept_name FROM tbl_departments WHERE dept_id=MT.department_id) AS department_name, MT.shift FROM tbl_manpower_team AS MT')->result();

    $this->global['pageTitle'] = 'Searbird : Manpower Teams List';
    $this->loadViews("manpower_teams_list", $this->global, $data, NULL);
  }

  function fetch_employees_from_team_id_post() {

    $all_employees = $this->db->query('SELECT name FROM tbl_users WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=' . $this->input->post('team_id') . ')')->result();

    $return_html = '<ul>';

    foreach ($all_employees as $employee) {

      $return_html .= '<li>' . $employee->name . '</li>';
    }

    $return_html .= '</ul>';

    echo $return_html;
  }

  function add_performance() {
    $post_data = $this->input->post();
//    pre($post_data);
    $superviserId = $this->session->userdata('userId');
//    $shiftMngtArray = getShiftMngtBySupervisor($superviserId);
//    $subDeptMngtArray = subDeptMngtByShifMngtId($shiftMngtArray['id']);
////    pre($subDeptMngtArray);
//    $departmentId = $shiftMngtArray['dept_id'];
//    $subDepartmentId = $shiftMngtArray['sub_dept_id'];
//    $shift = shiftName($shiftMngtArray['shift']);
////    $shift = $shiftMngtArray['shift'];
//    $organizationId = $shiftMngtArray['org_id'];
//    $locationId = locationIdByOrgId($organizationId);
//    $clientId = $subDeptMngtArray['client_id'];
//    $banchmark = $subDeptMngtArray['banchmark'];
//    $uom_name = $subDeptMngtArray['name'];

    $index_counter = 0;
    foreach ($post_data['employee_id'] as $employee_id) {

      $shiftMngtArray = getShiftMngtBySupervisor($superviserId, $post_data['dept_id'][$index_counter], $post_data['sub_dept_id'][$index_counter]);
      $subDeptMngtArray = subDeptMngtByShifMngtId($shiftMngtArray['id'], $post_data['dept_id'][$index_counter], $post_data['sub_dept_id'][$index_counter]);

      $departmentId = $shiftMngtArray['dept_id'];
      $subDepartmentId = $shiftMngtArray['sub_dept_id'];
      $shift = shiftName($shiftMngtArray['shift']);
//    $shift = $shiftMngtArray['shift'];
      $organizationId = $shiftMngtArray['org_id'];
      $locationId = locationIdByOrgId($organizationId);
      $clientId = $subDeptMngtArray['client_id'];
      $banchmark = $subDeptMngtArray['banchmark'];
      $uom_name = $subDeptMngtArray['name'];

//      $manpower_team_performance_query = $this->db->select('id')->from('tbl_manpower_team_performance')
//                      ->where('dept_id', $departmentId)
//                      ->where('sub_dept_id', $subDepartmentId)
//                      ->where('date', $post_data['report_date'][$index_counter])
//                      ->where('employee_id', $employee_id)->get();
      $selectQuery = 'SELECT id '
          . ' from tbl_manpower_team_performance'
          . ' WHERE superviser_id = ' . $superviserId . ' '
          . 'AND dept_id = ' . $departmentId . ' '
          . 'AND sub_dept_id = ' . $subDepartmentId . ' '
          . 'AND date = "' . $post_data['report_date'][$index_counter] . '"  '
          . 'AND employee_id = "' . $employee_id . '" '
          . 'AND wl_id = "' . $post_data['wl_id'][$index_counter] . '" '
          . '';
//      die;
      $query = $this->db->query($selectQuery);
//      $shiftMngtArray = getShiftMngtBySupervisor($superviserId, $post_data['dept_id'][$index_counter], $post_data['sub_dept_id'][$index_counter]);
//      $subDeptMngtArray = subDeptMngtByShifMngtId($shiftMngtArray['id'], $post_data['dept_id'][$index_counter], $post_data['sub_dept_id'][$index_counter]);

      if ($query->num_rows()) {
        if ($post_data['hours'][$index_counter] == '0' || $post_data['hours'][$index_counter] == '0') {
          $post_data['hours'][$index_counter] = '00:00:00';
        }

//        pre($subDeptMngtArray);
        $update_data = array(
          'wl_id' => $post_data['wl_id'][$index_counter],
          'dept_id' => $post_data['dept_id'][$index_counter],
          'sub_dept_id' => $post_data['sub_dept_id'][$index_counter],
          'superviser_id' => $superviserId,
          'shift' => $shift,
          'employee_id' => $employee_id,
          'employee_code' => empCodeByEmpId($employee_id),
          'co_emp_name' => empNameById($employee_id),
          'challans' => is_null($post_data['challans'][$index_counter]) ? 0 : $post_data['challans'][$index_counter],
          'A' => is_null($post_data['a'][$index_counter]) ? 0 : $post_data['a'][$index_counter],
          'B' => is_null($post_data['b'][$index_counter]) ? 0 : $post_data['b'][$index_counter],
          'C' => is_null($post_data['c'][$index_counter]) ? 0 : $post_data['c'][$index_counter],
          'kg' => is_null($post_data['kg'][$index_counter]) ? 0 : $post_data['kg'][$index_counter],
          'cfc' => is_null($post_data['cfc'][$index_counter]) ? 0 : $post_data['cfc'][$index_counter],
          'bins' => is_null($post_data['bins'][$index_counter]) ? 0 : $post_data['bins'][$index_counter],
          'pallet' => is_null($post_data['pallet'][$index_counter]) ? 0 : $post_data['pallet'][$index_counter],
          'line' => is_null($post_data['line'][$index_counter]) ? 0 : $post_data['line'][$index_counter],
          'time' => date('H:i:s', strtotime(productivityHour($post_data['from_time'][$index_counter], $post_data['to_time'][$index_counter]))), 'from_time' => is_null($post_data['from_time'][$index_counter]) ? '00:00:00' : date('H:i:s', strtotime($post_data['from_time'][$index_counter])),
          'to_time' => is_null($post_data['to_time'][$index_counter]) ? '00:00:00' : date('H:i:s', strtotime($post_data['to_time'][$index_counter])),
          'client' => $post_data['client_id'][$index_counter] ? $post_data['client_id'][$index_counter] : 0,
          'location' => $locationId ? $locationId : 0,
          'org' => $organizationId ? $organizationId : 0,
          'banchmark' => $subDeptMngtArray['banchmark'],
          'uom' => $subDeptMngtArray['name'],
          'date' => $post_data['report_date'][$index_counter],
        );
        $this->db->where(['dept_id' => $post_data['dept_id'][$index_counter], 'employee_id' => $employee_id, 'date' => $post_data['report_date'][$index_counter]]);
        $this->db->where(['sub_dept_id' => $post_data['sub_dept_id'][$index_counter]]);
        $this->db->where(['wl_id' => $post_data['wl_id'][$index_counter]]);
        $this->db->update('tbl_manpower_team_performance', $update_data);
      } else {
        if ($post_data['hours'][$index_counter] == '0' || $post_data['hours'][$index_counter] == '0') {
          $post_data['hours'][$index_counter] = '00:00:00';
        }
//        pre($subDeptMngtArray);
        $insert_data = array(
          'wl_id' => $post_data['wl_id'][$index_counter],
          'dept_id' => $post_data['dept_id'][$index_counter],
          'sub_dept_id' => $post_data['sub_dept_id'][$index_counter],
          'superviser_id' => $superviserId,
          'shift' => $shift,
          'employee_id' => $employee_id,
          'employee_code' => empCodeByEmpId($employee_id),
          'co_emp_name' => empNameById($employee_id),
          'challans' => is_null($post_data['challans'][$index_counter]) ? 0 : $post_data['challans'][$index_counter],
          'A' => is_null($post_data['a'][$index_counter]) ? 0 : $post_data['a'][$index_counter],
          'B' => is_null($post_data['b'][$index_counter]) ? 0 : $post_data['b'][$index_counter],
          'C' => is_null($post_data['c'][$index_counter]) ? 0 : $post_data['c'][$index_counter],
          'kg' => is_null($post_data['kg'][$index_counter]) ? 0 : $post_data['kg'][$index_counter],
          'cfc' => is_null($post_data['cfc'][$index_counter]) ? 0 : $post_data['cfc'][$index_counter],
          'bins' => is_null($post_data['bins'][$index_counter]) ? 0 : $post_data['bins'][$index_counter],
          'pallet' => is_null($post_data['pallet'][$index_counter]) ? 0 : $post_data['pallet'][$index_counter],
          'line' => is_null($post_data['line'][$index_counter]) ? 0 : $post_data['line'][$index_counter],
          'time' => date('H:i:s', strtotime(productivityHour($post_data['from_time'][$index_counter], $post_data['to_time'][$index_counter]))), 'from_time' => is_null($post_data['from_time'][$index_counter]) ? '00:00:00' : date('H:i:s', strtotime($post_data['from_time'][$index_counter])),
          'to_time' => is_null($post_data['to_time'][$index_counter]) ? '00:00:00' : date('H:i:s', strtotime($post_data['to_time'][$index_counter])),
          'client' => $post_data['client_id'][$index_counter] ? $post_data['client_id'][$index_counter] : 0,
          'location' => $locationId ? $locationId : 0,
          'org' => $organizationId ? $organizationId : 0,
          'banchmark' => $subDeptMngtArray['banchmark'],
          'uom' => $subDeptMngtArray['name'],
          'date' => $post_data['report_date'][$index_counter],
        );
//        pre($insert_data);
        $this->db->insert('tbl_manpower_team_performance', $insert_data);
      }
      $index_counter++;
    }
    $this->session->set_flashdata('message', '<div class="alert alert-success">Performance added successfully!</div>');
    redirect('view-report');
  }

  public function fetch_performance_stats() {

    $team_performance_data = $this->db->query('SELECT * FROM tbl_manpower_team_performance WHERE team_id=' . $this->input->post('team_id') . '')->result();

    $return_html = '
        <div class="row">
          <div class="col-xs-12">
            <table class="table table-striped listingtable">
              <thead>
                <tr class="listingtable-head">
                  <th>Employee</th>
                  <th>Challans</th>
                  <th>Picking</th>
                  <th>Packing</th>
                  <th>Dispatch</th>
                  <th>InBound</th>
                  <th>Binning</th>
                </tr>
              </thead>
            <tbody>';

    foreach ($team_performance_data as $rec) {

      $employee_name = $this->db->select('name')->from('tbl_users')->where('userId', $rec->employee_id)->get()->row()->name;

      $return_html .= '
            <tr class="odd">
                <td>' . $employee_name . '</td>
                <td>' . $rec->challans . '</td>
                <td>' . $rec->picking . '</td>
                <td>' . $rec->packing . '</td>
                <td>' . $rec->dispatch . '</td>
                <td>' . $rec->inbound . '</td>
                <td>' . $rec->binning . '</td>
            </tr>
            ';
    }

    $return_html .= '</tbody>
                </table>
            </div>
        </div>
        ';

    echo $return_html;
  }

  function fetch_add_performance_form() {
    $supervisorId = $this->session->userdata('userId');
//    $deptArray = departmentByUser($userId);
////    pre($deptArray);
//    $departmentId = $deptArray['department_id'];
//    $subDepartmentId = $deptArray['sub_department_id'];
//    $shiftId = $deptArray['shift'];
//    $orgId = $deptArray['org_id'];


    $postclientId = $this->input->post('clientId');
    $postdepartmentId = $this->input->post('departmentId');
    $postsubDepartmentId = $this->input->post('subdepartmentId');
    $shiftId = $this->input->post('shiftId');
    $todayDate = $this->input->post('date');
    $shiftName = shiftName($shiftId);
//    die;


    date_default_timezone_set("Asia/Calcutta");   //India time (GMT+5:30)
//    echo $todayDate = date('Y-m-d', '-1');
//    echo $todayDate = date('Y-m-d', strtotime(' -1 day'));
//    die;
//    $client_list = $this->db->from('tbl_clients')->get()->result_array();
//$all_employees = $this->db->query('SELECT U.userId, U.name, U.emp_id, U.emp_code, (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS department_name FROM tbl_users AS U WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=' . $this->input->post('team_id') . ')')->result();
    $currentStatus = "'1'";
    $selectQuery = 'SELECT '
        . ' wl.id as wl_id, '
        . ' wl.check_in, '
        . ' wl.check_out, '
        . ' wl.dept_id, '
        . ' wl.sub_dept_id, '
        . 'SEC_TO_TIME((TIME_TO_SEC(wl.check_out) - TIME_TO_SEC(wl.check_in))) AS `total_hours`,'
        . 'U.roleId AS user_role,'
        . 'U.designation, '
        . 'U.userId AS user_id, '
        . 'U.name AS employee_name, '
        . 'U.emp_code AS employee_code, '
        . 'U.email AS employee_email, '
        . 'U.userId AS employee_id, '
        . 'U.emp_code AS employee_code,'
        . ' U.current_status, '
        . ' (SELECT dept_name from `tbl_departments` where `dept_id`= wl.dept_id) as department_name, '
        . ' (SELECT sub_dept_name from `tbl_sub_departments` where `id`= wl.sub_dept_id) as sub_department_name FROM tbl_users AS U '
        . ' left Join working_logs wl on wl.user_id = U.userId'
//              . '  right Join working_logs wl on wl.user_id = U.userId'
//              . ' WHERE U.current_status = ' . $currentStatus . ' AND U.sub_department_id = ' . $this->input->post('subdepartment') . ' AND U.department_id = ' . $this->input->post('departmentId') . ' AND U.userId != ' . $supervisorId . ' and organization_id = ' . $this->organization_id . ' and U.roleId = 3 and wl.check_in like "' . $todayDate . '%"';
        . ' WHERE wl.superviser_id = ' . $this->session->userdata('userId') . ' AND wl.sub_dept_id = ' . $postsubDepartmentId . ' AND wl.client_id = ' . $postclientId . ' AND wl.dept_id = ' . $postdepartmentId . ' AND U.userId != ' . $supervisorId . ' AND U.current_status = "' . 1 . '" and wl.org_id = ' . $this->organization_id . ' and U.roleId = 3 and wl.check_in like "' . $todayDate . '%"';
//      die;
    $all_employees = $this->db->query($selectQuery)->result();
//    last_query();
//    pre($all_employees);
    $return_html = '<style> .error { border-color: red;
    } </style>';

    $return_html .= '<form action = "' . base_url() . 'add_performance" method = "post" onsubmit = "return validate_add_performance_form();" autocomplete = "off">';
    $return_html .= '<input type = "hidden" name = "team_id" value = "' . $this->input->post('team_id') . '">';
    $return_html .= '<div class = "row">';
    $return_html .= '<div class = "col-xs-12">';
    $return_html .= '<table class = "table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class = "listingtable-head">';
//$return_html .= '<th width = "10">Absent</th>';
    $return_html .= '<th>Name</th>';
//$return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';
    $return_html .= '<th>Client</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Sub Department</th>';
    $return_html .= '<th width = "120" style="padding: 0px 35px 0px 35px;">Challans</th>';
    $return_html .= '<th width = "120" style="padding: 0px 35px 0px 35px;">Boxes</th>';
    $return_html .= '<th width = "120" style="padding: 0px 35px 0px 35px;"> #Qty</th>';
    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">SKU</th>';

    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">KG</th>';
    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">CFC</th>';
    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">Bins</th>';
    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">Pallet</th>';
    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">Line</th>';
    $return_html .= '<th width="120" style="padding: 0px 80px 0px 80px;">Remark</th>';
    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">Start Time</th>';
    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">End Time</th>';
    $return_html .= '<th width="120" style="padding: 0px 35px 0px 35px;">Report Date</th>';
//    $return_html .= '<th width="120">Action</th>';
//    $return_html .= '<th width="120">Hours</th>';
//    $return_html .= '<th width="120">Client</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    $total_challans = 0;
    $total_a = 0;
    $total_b = 0;
    $total_c = 0;
    $total_kg = 0;
    $total_cfc = 0;
    $total_bins = 0;
    $total_pallet = 0;
    $total_line = 0;

    foreach ($all_employees as $employee) {
//      pre($employee);
      $employee_performance_data_query = $this->db->select(array('wl_id as wl_id', 'challans', 'A', 'B', 'C', 'kg', 'cfc', 'bins', 'pallet', 'client', 'absent', 'time', 'from_time', 'to_time'))->from('tbl_manpower_team_performance')
              ->where('employee_id', $employee->employee_id)
              ->where('dept_id', $postdepartmentId)
              ->where('sub_dept_id', $postsubDepartmentId)
              ->where('superviser_id', $supervisorId)
              ->where('client', $postclientId)
              ->where('wl_id', $employee->wl_id)
              ->where('shift', $shiftName)
              ->where('date', $todayDate)->group_by('wl_id')->get();
//      last_query();
//      $supervisorId = $this->session->userdata('userId');
////    $deptArray = departmentByUser($userId);
//////    pre($deptArray);
////    $departmentId = $deptArray['department_id'];
////    $subDepartmentId = $deptArray['sub_department_id'];
////    $shiftId = $deptArray['shift'];
////    $orgId = $deptArray['org_id'];
//
//
//      $postclientId = $this->input->post('clientId');
//      $postdepartmentId = $this->input->post('departmentId');
//      $postsubDepartmentId = $this->input->post('subdepartmentId');
//      $shiftId = $this->input->post('shiftId');

      $employee_performance_data = array(
        'challans' => 0,
        'A' => 0,
        'B' => 0,
        'C' => 0,
        'kg' => 0,
        'cfc' => 0,
        'bin' => 0,
        'pallet' => 0,
        'line' => 0,
        'from_time' => $deptArray['in_time'],
        'to_time' => $deptArray['out_time'],
        'time' => '00:00',
        'client' => '',
        'remark' => '',
        'absent' => '',
      );

      if ($employee_performance_data_query->num_rows()) {

        $employee_performance_data = $employee_performance_data_query->row_array();
      }
      $readOnlyTxt = '';
      if ($employee_performance_data['absent'] == '1') {
        $readOnlyTxt = 'readonly';
      }
//      last_query();
//      pre($employee_performance_data);
      $total_challans = $total_challans + $employee_performance_data['challans'];
      $total_a = $total_a + $employee_performance_data['A'];
      $total_b = $total_b + $employee_performance_data['B'];
      $total_c = $total_c + $employee_performance_data['C'];
      $total_kg = $total_kg + $employee_performance_data['kg'];
      $total_cfc = $total_cfc + $employee_performance_data['cfc'];
      $total_bins = $total_bins + $employee_performance_data['bins'];
      $total_pallet = $total_pallet + $employee_performance_data['pallet'];
      $total_line = $total_pallet + $employee_performance_data['line'];
      $outtime = $employee->check_out ? date('H:i', strtotime($employee->check_out)) : '';

      $return_html .= '<tr class="odd" id="' . $employee->employee_code . '">';
//      if ($employee_performance_data['absent'] == '1') {
//        $return_html .= '<td><input  type="checkbox" onclick="disableSiblingField(this)" value="1" checked> <input class="absent" type="hidden" name="absent[]" value="1"></td>';
//      } else {
//        $return_html .= '<td><input  type="checkbox" onclick="disableSiblingField(this)" value="1"> <input class="absent" type="hidden" name="absent[]" value="0"></td>';
//      }

      $return_html .= '<td>' . $employee->employee_name . '</td>';
//$return_html .= '<td>' . $employee->employee_id . '</td>';
      $return_html .= '<td>' . $employee->employee_code . '</td>';
      $return_html .= '<td>' . clientName($postclientId) . '</td>';
      $return_html .= '<td>' . $employee->department_name . '</td>';
      $return_html .= '<td>' . $employee->sub_department_name . '</td>';
//      ->where('dept_id', $postsubDepartmentId)
//                      ->where('sub_dept_id', $postsubDepartmentId)
//                      ->where('superviser_id', $supervisorId)
//                      ->where('client', $postclientId)
      $return_html .= '<input type="hidden" name="wl_id[]" value="' . $employee->wl_id . '">';
      $return_html .= '<input type="hidden" name="employee_id[]" value="' . $employee->employee_id . '">';
      $return_html .= '<input type="hidden" name="client_id[]" value="' . $postclientId . '">';
      $return_html .= '<input type="hidden" name="dept_id[]" value="' . $postdepartmentId . '">';
      $return_html .= '<input type="hidden" name="sub_dept_id[]" value="' . $postsubDepartmentId . '">';
//      $return_html .= '<input type="hidden" name="employee_id[]" value="' . $employee->employee_id . '">';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="challans[]" maxlength="6" value="' . $employee_performance_data['challans'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="a[]" maxlength="6" value="' . $employee_performance_data['A'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="b[]" maxlength="6" value="' . $employee_performance_data['B'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="c[]" maxlength="6" value="' . $employee_performance_data['C'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="kg[]" maxlength="6" value="' . $employee_performance_data['kg'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="cfc[]" maxlength="6" value="' . $employee_performance_data['cfc'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="bins[]" maxlength="6" value="' . $employee_performance_data['bins'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="pallet[]" maxlength="6" value="' . $employee_performance_data['pallet'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="line[]" maxlength="6" value="' . $employee_performance_data['line'] . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field" type="text" name="remark[]"  value="' . $employee_performance_data['remark'] . '"></td>';

      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hoursminute from_time_' . $employee->emp_id . '"  placeholder = "00:00" type="time" name="from_time[]"  value="' . date('H:i', strtotime($employee->check_in)) . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hoursminute to_time_' . $employee->emp_id . '"  placeholder = "00:00" type="time" name="to_time[]"   value="' . $outtime . '"></td>';
      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hoursminute report_date"  placeholder = "" type="text" name="report_date[]"   value="' . $todayDate . '"></td>';
//      $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hoursminute to_time_' . $employee->emp_id . '"  placeholder = "" type="text" name="remark[]"   value="' . $employee_performance_data['remark'] . '"></td>';
//      $return_html .= '<td><i class="fa fa-trash" onclick="myFunction(' . $employee->employee_code . ')" style="color:red; font-size:30px; padding-left:15px"></i></td>';
// $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hoursminute to_time_' . $employee->emp_id . '"  placeholder = "00:00" type="hidden" name="to_time[]"   value="' . date('H:i', strtotime($employee->check_out)) . '"></td>';
// $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hoursminute to_time_' . $employee->emp_id . '"  placeholder = "00:00" type="hidden" name="workinghour[]"   value="' . date('H:i', strtotime($employee->total_hours)) . '"></td>';
//      $return_html .= '<td><i class="fa fa-trash" onclick="myFun(' . $employee->employee_code . ')" style="color:red; font-size:30px; padding-left:15px"></i></td>';
// $return_html .= '<td><input ' . $readOnlyTxt . ' class="form-control form-field hourstest hours_' . $employee->emp_id . '" onkeypress="return false" placeholder = "00:00" type="text" name="hours[]" value="' . date('H:i', strtotime($employee_performance_data['time'])) . '"></td>';
// $return_html .= '<td><select ' . $readOnlyTxt . ' class="form-control"  name="client[]">';
//      $return_html .= '<option value="">Select</option>';
//      if (!empty($client_list)) {
//        foreach ($client_list as $client) {
//          $selectTxt = '';
//          if ($employee_performance_data['client'] == $client['client']) {
//            $selectTxt = 'selected';
//          }
//          $return_html .= '<option ' . $selectTxt . '  value="' . $client['client'] . '">' . $client['client'] . '</option>';
//        }
//      }
//      $return_html .= '</select></td>';

      $return_html .= '</tr>';
    }
    $return_html .= '<tr>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td><h4><b>Total</b></h4></td>';
    $return_html .= '<td><h4>' . $total_challans . '</h4></td>';
    $return_html .= '<td><h4>' . $total_a . '</h4></td>';
    $return_html .= '<td><h4>' . $total_b . '</h4></td>';
    $return_html .= '<td><h4>' . $total_c . '</h4></td>';
    $return_html .= '<td><h4>' . $total_kg . '</h4></td>';
    $return_html .= '<td><h4>' . $total_cfc . '</h4></td>';
    $return_html .= '<td><h4>' . $total_bins . '</h4></td>';
    $return_html .= '<td><h4>' . $total_pallet . '</h4></td>';
    $return_html .= '<td><h4>' . $total_line . '</h4></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '</tr>';

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '</div>';
    $return_html .= '<div class="col-xs-12" style="margin-top: 20px;"><button type="submit" class="btn btn-success">Submit</button></div>';
    $return_html .= '<div>';
    $return_html .= '</form> <script>$(".hoursminute").timepicker({\'timeFormat\': \'H:i\' });</script>';

//if ($(this).val() === \'\' || isNaN($(this).val())) {
    $return_html .= '
        <script>
            function validate_add_performance_form () {

                var form_is_error_free = true;

                $(".form-field").each(function(i, obj){

                    if ($(this).val() === \'\')) {

                        $(this).css(\'border-color\', \'red\');
                        form_is_error_free = false;

                    } else {

                        $(this).css(\'border-color\', \'\');
                    }
                });

                if (form_is_error_free) {

                    return true;
                } else {

                    return false;
                }
            }
        </script>
        ';

    echo $return_html;
  }

  function fetch_team_report_markup() {

    $all_employees = $this->db->query('SELECT U.userId, U.name, U.emp_id, U.emp_code, (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS department_name FROM tbl_users AS U WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=' . $this->input->post('team_id') . ')')->result();

    $return_html = '<style> .error { border-color: red; } </style>';

    $return_html .= '<form action="' . base_url() . 'add_performance" method="post" onsubmit="return validate_add_performance_form();" autocomplete="off">';
    $return_html .= '<input type="hidden" name="dept_id" value="' . $departmentId . '">';
    $return_html .= '<input type="hidden" name="sub_dept_id" value="' . $subDepartmentId . '">';
    $return_html .= '<div class="row">';
    $return_html .= '<div class="col-xs-12">';
    $return_html .= '<table class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th width="120">Challans</th>';
    $return_html .= '<th width="120">Boxes</th>';
    $return_html .= '<th width="120">#Qty</th>';
    $return_html .= '<th width="120">SKU</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    $total_challans = 0;
    $total_a = 0;
    $total_b = 0;
    $total_c = 0;

    foreach ($all_employees as $employee) {

      $employee_performance_data_query = $this->db->select(array('challans', 'A', 'B', 'C'))->from('tbl_manpower_team_performance')->where('team_id', $this->input->post('team_id'))->where('employee_id', $employee->userId)->get();

      $employee_performance_data = array(
        'challans' => 0,
        'A' => 0,
        'B' => 0,
        'C' => 0
      );

      if ($employee_performance_data_query->num_rows()) {

        $employee_performance_data = $employee_performance_data_query->row_array();
      }

      $total_challans = $total_challans + $employee_performance_data['challans'];
      $total_a = $total_a + $employee_performance_data['A'];
      $total_b = $total_b + $employee_performance_data['B'];
      $total_c = $total_c + $employee_performance_data['C'];

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $employee->name . '</td>';
      $return_html .= '<td>' . $employee->emp_id . '</td>';
      $return_html .= '<td>' . $employee->emp_code . '</td>';
      $return_html .= '<td>' . $employee->department_name . '</td>';
      $return_html .= '<input type="hidden" name="employee_id[]" value="' . $employee->userId . '">';
      $return_html .= '<td>' . $employee_performance_data['challans'] . '</td>';
      $return_html .= '<td>' . $employee_performance_data['A'] . '</td>';
      $return_html .= '<td>' . $employee_performance_data['B'] . '</td>';
      $return_html .= '<td>' . $employee_performance_data['C'] . '</td>';
      $return_html .= '</tr>';
    }
    $return_html .= '<tr>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td></td>';
    $return_html .= '<td><h4><b>Total</b></h4></td>';
    $return_html .= '<td><h4>' . $total_challans . '</h4></td>';
    $return_html .= '<td><h4>' . $total_a . '</h4></td>';
    $return_html .= '<td><h4>' . $total_b . '</h4></td>';
    $return_html .= '<td><h4>' . $total_c . '</h4></td>';
    $return_html .= '</tr>';

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '</div>';
    $return_html .= '<div>';
    $return_html .= '</form>';

    echo $return_html;
  }

  public function download_today_report($todays_team_id) {
    $total = 0;
    $userId = $supervisorId = $this->session->userdata('userId');
//    $departmentId = $this->session->userdata('department_id');
//    $subDepartmentId = $this->session->userdata('sub_department_id');
    $orgId = $this->session->userdata('organization_id');
    $locId = locationIdByOrgId($orgId);
    $clientId = clientIdByLocationId($locId);
    $client_list = $this->db->from('tbl_clients')->get()->result_array();
    $currentStatus = "'1'";
//    if ($departmentId != '') {
//      $this->db->where('tbl_manpower_team_performance.dept_id', $departmentId);
//    }
//    if ($subDepartmentId != '') {
//      $this->db->where('tbl_manpower_team_performance.sub_dept_id', $subDepartmentId);
//    }
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->where('date', date('Y-m-d'));
    $this->db->where('superviser_id', $supervisorId);
    $this->db->group_by('date,client,dept_id,sub_dept_id,shift,employee_id,id');
    $all_team_employees_list = $this->db->get('tbl_manpower_team_performance')->result();
    $filename = 'dailyreport_.xls';
    $data['total_challans'] = 0;
    $data['total_boxes'] = 0;
    $data['total_qty'] = 0;
    $data['total_sku'] = 0;
    $data['all_employees_data'] = array();
    $index_counter = 0;
    $empIdList = array();
//    pre($all_team_employees_list);
    foreach ($all_team_employees_list as $employee) {
//      if (!empty($empIdList) && in_array($employee->employee_id, $empIdList)) {
//        continue;
//      }
//      $empIdList[] = $employee->employee_id;
//      $data['all_employees_data'][$index_counter]['employee_name'] = $this->db->select('name')->from('tbl_users')->where('userId', $employee->employee_id)->get()->row()->name;
//      $data['all_employees_data'][$index_counter]['supervisor'] = $this->db->select('name')->from('tbl_users')->where('department_id', $employee->dept_id)->where('sub_department_id', $employee->sub_dept_id)->where('roleId', '4')->get()->row()->name;
//      $data['all_employees_data'][$index_counter]['dept_name'] = deptName($employee->dept_id);
//      $data['all_employees_data'][$index_counter]['org_name'] = orgName($employee->org);
//      $data['all_employees_data'][$index_counter]['sub_dept'] = $employee->sub_dept_id;
//      pre($employee);
      if ($employee->emp_type == 'Contractual') {
        $data['all_employees_data'][$index_counter]['employee_name'] = $employee->co_emp_name;
      } else {
        $data['all_employees_data'][$index_counter]['employee_name'] = empNameById($employee->employee_id) ? empNameById($employee->employee_id) : $employee->co_emp_name;
      }
//      $data['all_employees_data'][$index_counter]['employee_name'] = empNameById($employee->employee_id);
      $data['all_employees_data'][$index_counter]['employee_code'] = $employee->employee_code;
      $data['all_employees_data'][$index_counter]['supervisor'] = empNameById($employee->superviser_id);
      $data['all_employees_data'][$index_counter]['dept_name'] = deptName($employee->dept_id);
      $data['all_employees_data'][$index_counter]['org_name'] = orgName($employee->org);
      $data['all_employees_data'][$index_counter]['sub_dept_name'] = subDeptName($employee->sub_dept_id);
      $data['all_employees_data'][$index_counter]['client'] = clientName($employee->client);
      $data['all_employees_data'][$index_counter]['shift'] = $employee->shift;
      $data['all_employees_data'][$index_counter]['banchmark'] = $employee->banchmark;
      $data['all_employees_data'][$index_counter]['uom'] = $employee->uom;
      $data['all_employees_data'][$index_counter]['remark'] = $employee->remark;
//      die;

      $total_time_query = $this->db->select('time,emp_type')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_time_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_time'] = $total_time_query->row()->time;
        $data['all_employees_data'][$index_counter]['emp_type'] = $total_time_query->row()->emp_type;
      } else {
        $data['all_employees_data'][$index_counter]['total_time'] = '00:00';
        $data['all_employees_data'][$index_counter]['emp_type'] = '';
      }
      $total_challans_query = $this->db->select('challans,TIME_TO_SEC(time) as total_sec_worked')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_challans_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_challans'] = $total_challans_query->row()->challans;
        $data['all_employees_data'][$index_counter]['total_sec_worked'] = $total_challans_query->row()->total_sec_worked;
      } else {
        $data['all_employees_data'][$index_counter]['total_challans'] = 0;
        $data['all_employees_data'][$index_counter]['total_sec_worked'] = 0;
      }
      $total_boxes_query = $this->db->select('A')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_boxes_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_boxes'] = $total_boxes_query->row()->A;
      } else {
        $data['all_employees_data'][$index_counter]['total_boxes'] = 0;
      }
      $total_qty_query = $this->db->select('B')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_qty_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_qty'] = $total_qty_query->row()->B;
      } else {
        $data['all_employees_data'][$index_counter]['total_qty'] = 0;
      }
      $total_sku_query = $this->db->select('C')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_sku_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_sku'] = $total_sku_query->row()->C;
      } else {
        $data['all_employees_data'][$index_counter]['total_sku'] = 0;
      }

      $total_kg_query = $this->db->select('kg')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_kg_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_kg'] = $total_kg_query->row()->kg;
      } else {
        $data['all_employees_data'][$index_counter]['total_kg'] = 0;
      }
      $total_cfc_query = $this->db->select('cfc')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_cfc_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_cfc'] = $total_cfc_query->row()->cfc;
      } else {
        $data['all_employees_data'][$index_counter]['total_cfc'] = 0;
      }
      $total_bins_query = $this->db->select('bins')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_kg_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_bins'] = $total_bins_query->row()->bins;
      } else {
        $data['all_employees_data'][$index_counter]['total_bins'] = 0;
      }
      $total_pallet_query = $this->db->select('pallet')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_pallet_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_pallet'] = $total_pallet_query->row()->pallet;
      } else {
        $data['all_employees_data'][$index_counter]['total_pallet'] = 0;
      }
      $total_line_query = $this->db->select('line')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($total_pallet_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['total_line'] = $total_line_query->row()->line;
      } else {
        $data['all_employees_data'][$index_counter]['total_line'] = 0;
      }

      $chck_absent_query = $this->db->select('absent')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('id', $employee->id)->where('date', date('Y-m-d'))->get();
      if ($chck_absent_query->num_rows()) {
        $data['all_employees_data'][$index_counter]['absent'] = $chck_absent_query->row()->absent;
      } else {
        $data['all_employees_data'][$index_counter]['absent'] = 0;
      }

//      pre($data['all_employees_data']);
//      $time = array();
//      $data['total_time'] = $this->db->select('IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS time')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->time;
////      pre($data['total_time']);
//
//      $element = $total_time[$key1]['total_time'];
//      // Explode by seperator :
//      $temp = explode(":", $data['total_time']);
//
//      // Convert the hours into seconds
//      // and add to total
//      $total += (int) $temp[0] * 3600;
//
//      // Convert the minutes to seconds
//      // and add to total
//      $total += (int) $temp[1] * 60;
//
//      // Add the seconds to total
//      $total += (int) $temp[2];
////      $time[] = $data['total_time'];
////      $data['total_time'] = $this->AddPlayTime($time);
////      pre($data['total_time']);
//      $data['total_challans'] = $data['total_challans'] + $this->db->select('Sum(challans) as challans')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->challans;
//      $data['total_boxes'] = $data['total_boxes'] + $this->db->select('A')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->A;
//      $data['total_qty'] = $data['total_qty'] + $this->db->select('B')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->B;
//      $data['total_sku'] = $data['total_sku'] + $this->db->select('C')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->C;
//      $data['total_kg'] = $data['total_kg'] + $this->db->select('kg')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->kg;
//      $data['total_cfc'] = $data['total_cfc'] + $this->db->select('cfc')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->cfc;
//      $data['total_bins'] = $data['total_bins'] + $this->db->select('bins')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->bins;
//      $data['total_pallet'] = $data['total_pallet'] + $this->db->select('pallet')->from('tbl_manpower_team_performance')->where('superviser_id', $supervisorId)->where('employee_id', $employee->employee_id)->where('date', date('Y-m-d'))->get()->row()->pallet;
//      pre($data['all_employees_data'][$index_counter]['total_kg']);
      $data['total_challans'] += $data['all_employees_data'][$index_counter]['total_challans'];
      $data['total_boxes'] += $data['all_employees_data'][$index_counter]['total_boxes'];
      $data['total_qty'] += $data['all_employees_data'][$index_counter]['total_qty'];
      $data['total_sku'] += $data['all_employees_data'][$index_counter]['total_sku'];
//      pre($data['total_sku']);
      $data['total_kg'] += $data['all_employees_data'][$index_counter]['total_kg'];
      $data['total_cfc'] += $data['all_employees_data'][$index_counter]['total_cfc'];
      $data['total_bins'] += $data['all_employees_data'][$index_counter]['total_bins'];
      $data['total_pallet'] += $data['all_employees_data'][$index_counter]['total_pallet'];
      $data['total_line'] += $data['all_employees_data'][$index_counter]['total_line'];
//      pre($data);
      $index_counter++;
    }
    $this->load->library('excel');
//activate worksheet number 1
    $this->excel->setActiveSheetIndex(0);
//name the worksheet
    $this->excel->getActiveSheet()->setTitle('Today Report');

    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Superviser')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:G1')->setCellValue('B1', empNameById($supervisorId))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Date')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:G2')->setCellValue('B2', date('d-m-Y'))->getStyle('B2')->getFont()->setBold(true);

    $this->excel->getActiveSheet()->setCellValue('A3', 'Location Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B3', 'Warehouse')->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C3', 'Client Name')->getStyle('C3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D3', 'Department')->getStyle('D3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E3', 'Sub Department')->getStyle('E3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F3', 'Shift')->getStyle('F3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G3', 'Employee Name')->getStyle('G3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H3', 'Emp Code')->getStyle('H3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I3', 'Total Benchmark')->getStyle('I3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J3', 'Benchmark Unit (UOM)')->getStyle('J3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K3', 'Challan')->getStyle('K3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L3', 'Boxes')->getStyle('L3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('M3', 'Qty')->getStyle('M3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('N3', 'SKU')->getStyle('N3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('O3', 'KG')->getStyle('O3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('P3', 'CFC')->getStyle('P3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('Q3', 'Bins')->getStyle('Q3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('R3', 'Pallet')->getStyle('R3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('S3', 'Line')->getStyle('S3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('T3', 'Time')->getStyle('T3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('U3', 'Productivity')->getStyle('U3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('V3', '%age Achievement')->getStyle('V3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('W3', 'Remark')->getStyle('W3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('X3', 'Employee Type')->getStyle('X3')->getFont()->setBold(true);
    if (isset($data['all_employees_data']) && !empty($data['all_employees_data'])) {
      $excelrow = 4;
      foreach ($data['all_employees_data'] as $key => $emp) {
//        pre($employee);
//        pre($emp);
        if (isset($emp['absent']) && $emp['absent'] == 1) {
          $emp['total_challans'] = 'A';
          $emp['total_boxes'] = 'A';
          $emp['total_qty'] = 'A';
          $emp['total_sku'] = 'A';
          $emp['total_time'] = 'A';
        }
        $shiftMngt = getShiftMngtBySupervisor($employee->superviser_id, $employee->dept_id, $employee->sub_dept_id);
        $totalSec = (int) round($shiftMngt['total_sec_to_work'], '2');
//        echo $emp['uom'];
        $uomKey = 'total_' . $emp['uom'];
//        $uomKey = $challan['uom'];
//        pre($emp['banchmark']);
//        pre((($emp['banchmark']) * (($emp['total_sec_worked'])) . ' %'));
//        pre(($emp[$uomKey] / 1) * 100 * $totalSec);
        $AchivementPer = ((($emp[$uomKey] / 1) * 100 * $totalSec) / (($emp['banchmark']) * (($emp['total_sec_worked'])) . ' %'));
//        die;
        $AchivementPer = (integer) (round($AchivementPer)) ? round($AchivementPer) : '0';
//        echo $emp['total_' . $uomKey];
//        die;
//        die;
//        pre($emp);
//        die;

        $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(locationName($locId)));
        $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(orgName($orgId)));
        $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, ucfirst($emp['client']));
        $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, ucfirst($emp['dept_name']));
        $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, ucfirst($emp['sub_dept_name']));
        $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, ucfirst($emp['shift']));
        $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, ucfirst($emp['employee_name']));
        $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, ucfirst($emp['employee_code']));
        $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, ucfirst($emp['banchmark']));
        $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, ucfirst($emp['uom']));
        $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $emp['total_challans']);
        $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $emp['total_boxes']);
        $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $emp['total_qty']);
        $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $emp['total_sku']);
        $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $emp['total_kg']);
        $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $emp['total_cfc']);
        $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $emp['total_bins']);
        $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $emp['total_pallet']);
        $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, $emp['total_line']);
        $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, $emp['total_time']);
        $this->excel->getActiveSheet()->setCellValue('U' . $excelrow, ($emp[$uomKey] / 1));
        $this->excel->getActiveSheet()->setCellValue('V' . $excelrow, abs($AchivementPer));
        $this->excel->getActiveSheet()->setCellValue('W' . $excelrow, $emp['remark']);
        $this->excel->getActiveSheet()->setCellValue('X' . $excelrow, $emp['emp_type']);

        // Explode by seperator :
        $temp = explode(":", $emp['total_time']);

        // Convert the hours into seconds
        // and add to total
        $total += (int) $temp[0] * 3600;

        // Convert the minutes to seconds
        // and add to total
        $total += (int) $temp[1] * 60;

        // Add the seconds to total
        $total += (int) $temp[2];

        $excelrow++;
      }
//      pre(secToTime($total));
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, 'Total : ')->getStyle('A' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $data['total_challans']);
      $this->excel->getActiveSheet()->setCellValue('L' . $excelrow, $data['total_boxes']);
      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, $data['total_qty']);
      $this->excel->getActiveSheet()->setCellValue('N' . $excelrow, $data['total_sku']);
      $this->excel->getActiveSheet()->setCellValue('O' . $excelrow, $data['total_kg']);
      $this->excel->getActiveSheet()->setCellValue('P' . $excelrow, $data['total_cfc']);
      $this->excel->getActiveSheet()->setCellValue('Q' . $excelrow, $data['total_bins']);
      $this->excel->getActiveSheet()->setCellValue('R' . $excelrow, $data['total_pallet']);
      $this->excel->getActiveSheet()->setCellValue('S' . $excelrow, $data['total_line']);
      $this->excel->getActiveSheet()->setCellValue('T' . $excelrow, secToTime($total));
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//if you want to save it as .XLSX Excel 2007 format
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//force user to download the Excel file without writing it to server's HD
    $objWriter->save('php://output');
    redirect(site_url('view-report'));
    die;
  }

  function headGroupByClient() {
    $this->load->helper('report');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Location')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Warehouse')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Department')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Sub Department')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Supervisor')->getStyle('F1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('G1', 'Date')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Challan')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'Boxes')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Qty')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K1', 'SKU')->getStyle('K1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L1', 'Manpower')->getStyle('L1')->getFont()->setBold(true);
  }

  function headGroupByLocation() {
    $this->load->helper('report');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Location')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Warehouse')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Department')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Sub Department')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Supervisor')->getStyle('F1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('G1', 'Date')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Challan')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'Boxes')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Qty')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K1', 'SKU')->getStyle('K1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L1', 'Manpower')->getStyle('L1')->getFont()->setBold(true);
  }

  function headGroupByOrg() {
    $this->load->helper('report');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Location')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Warehouse')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Department')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Sub Department')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Supervisor')->getStyle('F1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('G1', 'Date')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Challan')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'Boxes')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Qty')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K1', 'SKU')->getStyle('K1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L1', 'Manpower')->getStyle('L1')->getFont()->setBold(true);
  }

  function headGroupByDept() {
    $this->load->helper('report');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Location')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Warehouse')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Department')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Sub Department')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Supervisor')->getStyle('F1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('G1', 'Date')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Challan')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'Boxes')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Qty')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K1', 'SKU')->getStyle('K1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L1', 'Manpower')->getStyle('L1')->getFont()->setBold(true);
  }

  function headGroupBySubDept() {
    $this->load->helper('report');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Location')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Warehouse')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Department')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Sub Department')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Supervisor')->getStyle('F1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('G1', 'Date')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Challan')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'Boxes')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Qty')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('K1', 'SKU')->getStyle('K1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('L1', 'Manpower')->getStyle('L1')->getFont()->setBold(true);
  }

  function get_date_ranged_report_excel_new() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift = $this->session->userdata('shift');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('organizationId');
      $shift = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $filename = 'manpower_productivity_' . $departmentName . '_' . $shift . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);

//$this->headGroupByClient();


    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Location')->getStyle('B1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('C1', 'Warehouse')->getStyle('C1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('D1', 'Department')->getStyle('D1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('E1', 'Sub Department')->getStyle('E1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('F1', 'Supervisor')->getStyle('F1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('G1', 'Date')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Challan')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Boxes')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Qty')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'SKU')->getStyle('K1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Manpower')->getStyle('L1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Time')->getStyle('K1')->getFont()->setBold(true);

    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 2;
      foreach ($all_team_ids as $key => $team_id) {
        $where = ' ';
        $select = ' ';
        $groupBY = '  GROUP BY client';
        if ($sub_department_id != '' && $sub_department_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
          $groupBY = ' GROUP BY sub_dept_id';
        } elseif ($sub_department_id == 'all') {
          $groupBY = ' GROUP BY sub_dept_id';
        }
        if ($department_id != '' && $department_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
          $groupBY = ' GROUP BY dept_id';
        } elseif ($department_id == 'all') {
          $groupBY = ' GROUP BY dept_id';
        }
        if ($organization_id != '' && $organization_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
          $groupBY = ' GROUP BY org';
        } elseif ($organization_id == 'all') {
          $groupBY = ' GROUP BY org';
        }
        if ($location_id != '' && $location_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
          $groupBY = ' GROUP BY location';
        } elseif ($location_id == 'all') {
          $groupBY = ' GROUP BY location';
        }
        if ($client_id != '' && $client_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
          $groupBY = ' GROUP BY client';
        } elseif ($client_id == 'all') {
          $groupBY = ' GROUP BY client';
        }

        $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
        $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND absent = \'0\' ' . $where . $groupBY)->result_array();
        $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
        if (!empty($total_challans)) {
          foreach ($total_challans as $key1 => $challan) {
            $fChallan += $TCHALLAN = $challan['total_challans'];
            $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
            $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
            $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
            $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
            $TOTALTIME = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;

            $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(clientName($challan['client'])));
            $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(locationName($challan['location'])));
//            $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, ucfirst(orgName($challan['org'])));
//            $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, ucfirst(deptName($challan['dept_id'])));
//            $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, ucfirst(subDeptName($challan['sub_dept_id'])));
//            $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, ucfirst(superviserBySubDeptId($challan['sub_dept_id'])));
//            $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
            $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TCHALLAN);
            $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $TOTALBOXES);
            $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TOTALQTY);
            $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALSKU);
            $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALMANPOWER);
//$this->excel->getActiveSheet()->setCellValue('K'.$excelrow, $TOTALTIME);

            fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
            $excelrow++;
          }
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('E' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fEmp);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_detailed_report() {
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift = $this->session->userdata('shift');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('organizationId');
      $shift = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $filename = 'manpower_productivity_' . $departmentName . '_' . $shift . '_' . $fromDate . '_to_' . $toDate . '.xls';
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $all_team_ids = $this->db->get('tbl_manpower_team_performance')->result();
    $totalcount = count($all_team_ids);

//$this->headGroupByClient();


    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Client')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Location')->getStyle('B1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('C1', 'Warehouse')->getStyle('C1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('D1', 'Department')->getStyle('D1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('E1', 'Sub Department')->getStyle('E1')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue('F1', 'Supervisor')->getStyle('F1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Date')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Challan')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Boxes')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Qty')->getStyle('J1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'SKU')->getStyle('K1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Manpower')->getStyle('L1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Time')->getStyle('K1')->getFont()->setBold(true);

    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 2;
      foreach ($all_team_ids as $key => $team_id) {
        $where = ' ';
        $select = ' ';
        $groupBY = '  GROUP BY client';
        if ($sub_department_id != '' && $sub_department_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
          $groupBY = ' GROUP BY sub_dept_id';
        } elseif ($sub_department_id == 'all') {
          $groupBY = ' GROUP BY sub_dept_id';
        }
        if ($department_id != '' && $department_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
          $groupBY = ' GROUP BY dept_id';
        } elseif ($department_id == 'all') {
          $groupBY = ' GROUP BY dept_id';
        }
        if ($organization_id != '' && $organization_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
          $groupBY = ' GROUP BY org';
        } elseif ($organization_id == 'all') {
          $groupBY = ' GROUP BY org';
        }
        if ($location_id != '' && $location_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
          $groupBY = ' GROUP BY location';
        } elseif ($location_id == 'all') {
          $groupBY = ' GROUP BY location';
        }
        if ($client_id != '' && $client_id != 'all') {
          $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
          $groupBY = ' GROUP BY client';
        } elseif ($client_id == 'all') {
          $groupBY = ' GROUP BY client';
        }
        $groupBY = '  GROUP BY date';
        $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
        $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND absent = \'0\' ' . $where . $groupBY)->result_array();
        $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' AND client != \'\' ' . $where . $groupBY)->result_array();
        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ' . $where . $groupBY)->result_array();
        if (!empty($total_challans)) {
          foreach ($total_challans as $key1 => $challan) {
            $fChallan += $TCHALLAN = $challan['total_challans'];
            $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
            $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
            $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
            $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
            $TOTALTIME = isset($total_time[$key1]['total_time']) ? date('H:i', strtotime($total_time[$key1]['total_time'])) : 0;

            $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(clientName($challan['client'])));
            $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(locationName($challan['location'])));
//            $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, ucfirst(orgName($challan['org'])));
//            $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, ucfirst(deptName($challan['dept_id'])));
//            $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, ucfirst(subDeptName($challan['sub_dept_id'])));
//            $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, ucfirst(superviserBySubDeptId($challan['sub_dept_id'])));
            $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
            $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $TCHALLAN);
            $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $TOTALBOXES);
            $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $TOTALQTY);
            $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TOTALSKU);
            $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALMANPOWER);
//$this->excel->getActiveSheet()->setCellValue('K'.$excelrow, $TOTALTIME);

            fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
            $excelrow++;
          }
        }
      }
      $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, 'Total : ')->getStyle('E' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fEmp);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel() {
    $department_id = $this->session->userdata('department_id');
    $subDepartmentId = $this->session->userdata('sub_department_id');
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $this->db->join('tbl_users', 'tbl_users.userId = tbl_manpower_team_performance.employee_id');
    $this->db->join('tbl_roles', 'tbl_roles.roleId = tbl_users.roleId');
    $created_by = $this->db->get('tbl_manpower_team_performance')->result_array();
    $filename = 'manpower_productivity.xls';
    $this->load->library('excel');
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Department')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('D1', 'Date')->getStyle('D1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B1', 'Sub Department')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('C1', 'Client')->getStyle('C1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('E1', 'Supervisor')->getStyle('E1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('F1', 'Challan')->getStyle('F1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('G1', 'Boxes')->getStyle('G1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('H1', 'Qty')->getStyle('H1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('I1', 'SKU')->getStyle('I1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('J1', 'Manpower')->getStyle('J1')->getFont()->setBold(true);
//$this->excel->getActiveSheet()->setCellValue('K1', 'Time')->getStyle('K1')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;

    if (!empty($created_by)) {
      $excelrow = 2;
      foreach ($created_by as $key => $team_id) {
        $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' GROUP BY date')->result_array();
        $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  GROUP BY date')->result_array();
        $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  GROUP BY date')->row_array();

        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date FROM tbl_manpower_team_performance WHERE sub_dept_id=\'' . $team_id['sub_dept_id'] . '\' AND date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  GROUP BY date')->result_array();
        if (!empty($total_challans)) {
          foreach ($total_challans as $key1 => $challan) {
            $fChallan += $TCHALLAN = $challan['total_challans'];
            $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
            $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
            $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
            $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;

            $TOTALTIME = isset($total_time[$key1]['total_time']) ? $total_time[$key1]['total_time'] : 0;

            if ($TOTALTIME != '00:00:00' && $TOTALTIME != 0) {
// $TOTALTIME = date('H:i',strtotime($TOTALTIME));
            }

            $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(deptName($team_id['dept_id'])));
            $this->excel->getActiveSheet()->setCellValue('D' . $excelrow, date('d-m-Y', strtotime($challan['date'])));
            $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(subDeptName($team_id['sub_dept_id'])));
            $this->excel->getActiveSheet()->setCellValue('C' . $excelrow, clientName($challan['client']));
            $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, ucfirst($this->session->userdata('name')));
            $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $TCHALLAN);
            $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $TOTALBOXES);
            $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $TOTALQTY);
            $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $TOTALSKU);
            $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $TOTALMANPOWER);
//$this->excel->getActiveSheet()->setCellValue('K' . $excelrow, $TOTALTIME);

            fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);
            $excelrow++;
          }
        }
      }
      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, 'Total : ')->getStyle('E' . $excelrow)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fChallan);
      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fBoxes);
      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fQty);
      $this->excel->getActiveSheet()->setCellValue('I' . $excelrow, $fSku);
      $this->excel->getActiveSheet()->setCellValue('J' . $excelrow, $fEmp);
    }

//set cell A1 content with some text
//$this->excel->getActiveSheet()->setCellValue('A1', 'This is just some text value');
//change the font size
//$this->excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(20);
//make the font become bold
//$this->excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
//merge cell A1 until D1
//$this->excel->getActiveSheet()->mergeCells('A1:D1');
//set aligment to center for that merged cell (A1 to D1)
//$this->excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
//save our workbook as this file name
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
//save it to Excel5 format (excel 2003 .XLS file), change this to 'Excel2007' (and adjust the filename extension, also the header mime type)
//if you want to save it as .XLSX Excel 2007 format
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
//force user to download the Excel file without writing it to server's HD
    $objWriter->save('php://output');
    die;

    /* header('Content-Type: text/csv; charset=utf-8');
      header('Content-Disposition: attachment; filename=data.csv');
      $output = fopen('php://output', 'w');

      fputcsv($output, array('Shift', 'Client', 'Department','Date','Created By','Total Challans','Total Boxes','Total Qty','Total SKU','Manpower'));





      $TChallan = 0;
      $TBOXES = 0;
      $TQTY = 0;
      $TSKU = 0;
      $TMANPOWER = 0;

      foreach ($all_team_ids as $team_id) {

      $team_details = $this->db->query('SELECT MT.date AS date, (SELECT name FROM tbl_users WHERE userId=MT.created_by) AS created_by, MT.shift AS shift, MT.client AS client, (SELECT dept_name FROM tbl_departments WHERE dept_id=MT.department_id) AS department_name FROM tbl_manpower_team AS MT WHERE id='.$team_id->id)->row();

      //$total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\'')->row()->total_challans;
      $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans,date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' GROUP BY date')->result_array();


      //$total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\'')->row()->total_boxes;
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes, date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' GROUP BY date')->result_array();
      //$total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\'')->row()->total_qty;
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' GROUP BY date')->result_array();
      //$total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\'')->row()->total_sku;
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku, date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' GROUP BY date')->result_array();

      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND date >=\''.$this->input->post('from_date').'\' AND date <= \''.$this->input->post('to_date').'\' AND absent = \'0\' GROUP BY date')->result_array();

      $all_team_member_ids = $this->db->query('SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=\''.$team_id->id.'\'')->result();



      if(!empty($total_challans)){
      foreach ($total_challans as $key=> $challan){
      $TChallan += $challan['total_challans'];
      $TBOXES += $total_boxes[$key]['total_boxes'];
      $TQTY += $total_qty[$key]['total_qty'];
      $TSKU += $total_sku[$key]['total_sku'];
      $TMANPOWER += $total_manpower[$key]['manpower'];
      fputcsv($output,[$team_details->shift,'',$team_details->department_name,$challan['date'],$team_details->created_by,$challan['total_challans'],$total_boxes[$key]['total_boxes'],$total_qty[$key]['total_qty'],$total_sku[$key]['total_sku'],$total_manpower[$key]['manpower']]);
      }
      }



      fputcsv($fp, [$team_details->shift,$team_details->client,$team_details->department_name,$team_details->date,$team_details->created_by]);
      }
      fputcsv($output,['','','','','Total : ',$TChallan,$TBOXES,$TQTY,$TSKU,$TMANPOWER]);
      exit; */

    /*  foreach ($all_team_member_ids as $team_member_id) {

      $employee_name = $this->db->query('SELECT name FROM tbl_users WHERE userId=\''.$team_member_id->employee_id.'\'')->row()->name;

      $total_challans = $this->db->query('SELECT IFNULL(challans, 0) AS challans FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND employee_id=\''.$team_member_id->employee_id.'\'')->row()->challans;

      $total_boxes = $this->db->query('SELECT IFNULL(A, 0) AS boxes FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND employee_id=\''.$team_member_id->employee_id.'\'')->row()->boxes;

      $total_qty = $this->db->query('SELECT IFNULL(B, 0) AS qty FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND employee_id=\''.$team_member_id->employee_id.'\'')->row()->qty;

      $total_sku = $this->db->query('SELECT IFNULL(C, 0) AS sku FROM tbl_manpower_team_performance WHERE team_id=\''.$team_id->id.'\' AND employee_id=\''.$team_member_id->employee_id.'\'')->row()->sku;


      }



      } */




    exit;
  }

  function get_date_range_report_new_data() {
    $return_array = array();
    $departmentId = $this->input->post('departmentId');
    $subDepartmentId = $this->input->post('subdepartment');
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $shift = $this->input->post('shift');
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('tbl_manpower_team_performance.sub_dept_id');
    $this->db->join('tbl_users', 'tbl_users.userId = tbl_manpower_team_performance.employee_id');
    $this->db->join('tbl_roles', 'tbl_roles.roleId = tbl_users.roleId');
    $all_teams = $this->db->get('tbl_manpower_team_performance')->result_array();
    $totalcount = count($all_teams);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $tTime = '00:00';

    if (!empty($all_teams)) {

      $excelrow = 2;

      foreach ($all_teams as $key => $team_id) {

        if ($subDepartmentId != '') {
          $this->db->where('tbl_manpower_team_performance.dept_id', $departmentId);
        }
        if ($subDepartmentId != '') {
          $this->db->where('tbl_manpower_team_performance.sub_dept_id', $subDepartmentId);
        }
        $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans,date FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ')->row()->total_challans;
        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\'  ')->row()->total_boxes;
        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ')->row()->total_qty;
        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ')->row()->total_sku;
        $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ')->row()->manpower;
        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date FROM tbl_manpower_team_performance WHERE  date >=\'' . $this->input->post('from_date') . '\' ')->row()->total_time;
        $time = array();
        $time[] = $total_time;
        $time[] = $tTime;
        $tTime = $this->AddPlayTime($time);
        $fChallan = $fChallan + $total_challans;
        $fBoxes = $fBoxes + $total_boxes;
        $fQty = $fQty + $total_qty;
        $fSku = $fSku + $total_sku;
      }
    }
    $return_array['total_challan'] = $fChallan;
    $return_array['total_boxes'] = $fBoxes;
    $return_array['total_qty'] = $fQty;
    $return_array['total_sku'] = $fSku;
    $return_array['total_time'] = $tTime;
    echo json_encode($return_array);
    die;
  }

  function get_date_range_report_data() {
    $return_array = array();
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
      $shift = $this->session->userdata('shift');
    } else {
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $client_id = $this->input->post('clientId');
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('organizationId');
      $shift = $this->input->post('shift');
    }
    $this->db->select('created_by');
    $this->db->where(['department_id' => $department_id, 'shift' => $shift, 'team_submitted' => '1']);
    $created_by = $this->db->get('tbl_manpower_team')->row()->created_by;
    if ($department_id != '' && $department_id != 'all') {
      $where = ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
    }
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
    }

    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
    }
    $return_array['total_challan'] = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE date >= \'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\'' . $where)->row()->total_challans;

    $return_array['total_boxes'] = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes FROM tbl_manpower_team_performance WHERE date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\'' . $where)->row()->total_boxes;

    $return_array['total_qty'] = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty FROM tbl_manpower_team_performance WHERE  date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ' . $where)->row()->total_qty;

    $return_array['total_sku'] = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku FROM tbl_manpower_team_performance WHERE  date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ' . $where)->row()->total_sku;

    $return_array['total_time'] = $this->db->query('SELECT SEC_TO_TIME(SUM(TIME_TO_SEC(time))) AS total_time FROM tbl_manpower_team_performance WHERE date >= \'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ' . $where)->row()->total_time;

    if ($return_array['total_time'] != '00:00:00' && $return_array['total_time'] != '0') {

    } elseif ($return_array['total_time'] == '0') {
      $return_array['total_time'] = '-';
    }



    $return_array['detailed_performance_table_markup'] = '
        <table class="table">
            <thead>
                <tr>
                    <th>Employee Name</th>
                    <th>Challans</th>
                    <th>Boxes</th>
                    <th>#QTY</th>
                    <th>SKU</th>
                    <th>Time</th>
                </tr>
            </thead>
            <tbody>
        ';
    if ($department_id != '') {
      $this->db->where('tbl_manpower_team_performance.dept_id', $department_id);
    }
    if ($sub_department_id != '') {
      $this->db->where('tbl_manpower_team_performance.sub_dept_id', $sub_department_id);
    }
    $this->db->select('tbl_manpower_team_performance.*');
    $this->db->group_by('employee_id');
    $all_team_member_ids = $this->db->get('tbl_manpower_team_performance')->result();
    if (empty($all_team_member_ids)) {
      $return_array['detailed_performance_table_markup'] .= '
            <tr>
                <td>N/A</td>
                <td>N/A</td>
                <td>N/A</td>
                <td>N/A</td>
                <td>N/A</td>
                <td>N/A</td>
            </tr>
            ';
    } else {

      foreach ($all_team_member_ids as $team_member_id) {
        $team_member_name = $this->db->select('name')->from('tbl_users')->where('userId', $team_member_id->employee_id)->get()->row()->name;

        $total_challans = $this->db->query('SELECT IFNULL(SUM(challans), 0) AS total_challans FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_challans;

        $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_boxes;

        $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_qty;

        $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_sku;

        $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))), 0) AS total_time FROM tbl_manpower_team_performance WHERE employee_id=\'' . $team_member_id->employee_id . '\' AND date>=\'' . $this->input->post('from_date') . '\' AND date<=\'' . $this->input->post('to_date') . '\' ')->row()->total_time;

        if ($total_time != '00:00:00' && $total_time != 0) {
          $total_time = date('H:i', strtotime($total_time));
        } elseif ($total_time == 0) {
          $total_time = '-';
        }

        $return_array['detailed_performance_table_markup'] .= '
                <tr>
                    <td>' . $team_member_name . '</td>
                    <td>' . $total_challans . '</td>
                    <td>' . $total_boxes . '</td>
                    <td>' . $total_qty . '</td>
                    <td>' . $total_sku . '</td>
                    <td>' . $total_time . '</td>
                </tr>
                ';
      }
    }
    $return_array['detailed_performance_table_markup'] .= '</tbody></table>';
    echo json_encode($return_array);
    die;
  }

  function view_report_new() {
    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == 10) {
      $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
      $this->db->where_in('id', $lientIdsArray);
      $clientList = $this->db->get('tbl_clients')->result_array();
    } else {
      $clientList = $this->db->get('tbl_clients')->result_array();
    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    if ($this->role == '12') {
      $locationList = $this->db->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')->where('client_id', $clientId)->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('loc_id', $locationId)->get('tbl_organization')->result_array();
    }
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    $departmentList = $this->user_model->getDepartmentList($warehouseId);
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;
    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new", $this->global, $data, NULL);
  }

  function view_report() {


    $userId = $superviserId = $this->session->userdata('userId');
    $shiftMngtArray = getShiftMngtBySupervisor($superviserId);
    $subDeptMngtArray = subDeptMngtByShifMngtId($shiftMngtArray['id']);
    $department_id = $shiftMngtArray['dept_id'];
    $sub_department_id = $shiftMngtArray['sub_dept_id'];
    $shift = shiftName($shiftMngtArray['shift']);
    $orgId = $shiftMngtArray['org_id'];
    $locationId = locationIdByOrgId($organizationId);
    $clientId = $subDeptMngtArray['client_id'];
    $banchmark = $subDeptMngtArray['banchmark'];

//    $department_id = $this->session->userdata('department_id');
//    $sub_department_id = $this->session->userdata('sub_department_id');
//    $orgId = $this->session->userdata('organization_id');
//    $userId = $this->session->userdata('userId');
//    echo $shift = $this->session->userdata('shift');
//    die;
    $this->db->select('created_by');
    $this->db->where(['department_id' => $department_id, 'shift' => $shift, 'team_submitted' => '1']);
    $created_by = $this->db->get('tbl_manpower_team')->row()->created_by;
    $todays_team_id_query = $this->db->select('id')->from('tbl_manpower_team')->where('team_submitted', 1)->where('created_by', $created_by)->get();
    $data['total_challans'] = 0;
    $data['total_boxes'] = 0;
    $data['total_qty'] = 0;
    $data['total_sku'] = 0;
    $data['total_kg'] = 0;
    $data['total_bins'] = 0;
    $data['total_cfc'] = 0;
    $data['total_pallet'] = 0;
    $data['total_time'] = '00:00';
    $data['all_employees_data'] = array();
    $data['today_team_id'] = '';

    $todays_team_id = $this->create_team_and_add_supervisor_if_team_does_not_exist();

    if ($todays_team_id) {
      $data['today_team_id'] = $todays_team_id;
//      if ($department_id != '') {
//        $this->db->where('tbl_manpower_team_performance.dept_id', $department_id);
//      }
//      if ($sub_department_id != '') {
//        $this->db->where('tbl_manpower_team_performance.sub_dept_id', $sub_department_id);
//      }
      $this->db->select('tbl_manpower_team_performance.*');
//      $this->db->group_by('client,dept_id,sub_dept_id,shift,employee_id');
      $this->db->group_by('employee_code,employee_id');
      $this->db->where('date', date('Y-m-d'));
      $this->db->where('superviser_id', $superviserId);
      $all_team_member_ids = $this->db->get('tbl_manpower_team_performance')->result();
//      pre($all_team_member_ids);
      $all_team_employees_list = $all_team_member_ids;
      $index_counter = 0;
      $empIdList = array();
      foreach ($all_team_employees_list as $employee) {
//        pre($employee);
        if ($employee->emp_type != 'Contractual') {
          $data['all_employees_data'][$index_counter]['employee_name'] = $this->db->select('name')->from('tbl_users')->where('userId', $employee->employee_id)->get()->row()->name;
        } else {
          $data['all_employees_data'][$index_counter]['employee_name'] = $employee->co_emp_name;
        }$total_challans_query = $this->db->select('sum(challans) challans')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_challans_query->num_rows()) {
//          echo $this->db->last_query();
          $data['all_employees_data'][$index_counter]['total_challans'] = $total_challans_query->row()->challans;
        } else {

          $data['all_employees_data'][$index_counter]['total_challans'] = 0;
        }
        $total_boxes_query = $this->db->select('sum(A) A')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_boxes_query->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_boxes'] = $total_boxes_query->row()->A;
        } else {
          $data['all_employees_data'][$index_counter]['total_boxes'] = 0;
        }
        $total_qty_query = $this->db->select('sum(B) B')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_qty_query->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_qty'] = $total_qty_query->row()->B;
        } else {
          $data['all_employees_data'][$index_counter]['total_qty'] = 0;
        }
        $total_sku_query = $this->db->select('sum(C) C')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_sku_query->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_sku'] = $total_sku_query->row()->C;
        } else {
          $data['all_employees_data'][$index_counter]['total_sku'] = 0;
        }
        $total_kg_query = $this->db->select('sum(kg) kg')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_kg_query->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_kg'] = $total_kg_query->row()->kg;
        } else {
          $data['all_employees_data'][$index_counter]['total_kg'] = 0;
        }
        $total_cfc_query = $this->db->select('sum(cfc) cfc')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_cfc_query->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_cfc'] = $total_cfc_query->row()->cfc;
        } else {
          $data['all_employees_data'][$index_counter]['total_cfc'] = 0;
        }
        $total_bins_query = $this->db->select('sum(bins) bins')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_bins_query->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_bins'] = $total_bins_query->row()->bins;
        } else {
          $data['all_employees_data'][$index_counter]['total_bins'] = 0;
        }
        $total_pallet_query = $this->db->select('sum(pallet) pallet')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_pallet_query->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_pallet'] = $total_pallet_query->row()->pallet;
        } else {
          $data['all_employees_data'][$index_counter]['total_pallet'] = 0;
        }

        $total_line_query = $this->db->select('sum(line) line')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();
        if ($total_line_query->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_line'] = $total_line_query->row()->line;
        } else {
          $data['all_employees_data'][$index_counter]['total_line'] = 0;
        }
        $total_time = $this->db->select('SEC_TO_TIME( SUM( TIME_TO_SEC( `time` ) ) ) time,SUM(TIME_TO_SEC(time)) as total_sec_worked,')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get();

//        pre($total_time->row()->time);
        if ($total_time->num_rows()) {
          $data['all_employees_data'][$index_counter]['total_time'] = date('H:i', strtotime($total_time->row()->time));
          $data['all_employees_data'][$index_counter]['total_sec_worked'] = date('H:i', strtotime($total_time->row()->total_sec_worked));
        } else {

          $data['all_employees_data'][$index_counter]['total_time'] = '00:00';
          $data['all_employees_data'][$index_counter]['total_sec_worked'] = '0';
        }
        $index_counter++;
        $data['total_challans'] = $data['total_challans'] + $this->db->select('sum(challans) challans')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->challans;
        if ($employee->employee_id == 42) {

        }
//        pre($data['all_employees_data']);

        $data['total_boxes'] = $data['total_boxes'] + $this->db->select('sum(A) A')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->A;

        $data['total_qty'] = $data['total_qty'] + $this->db->select('sum(B) B')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->B;

        $data['total_sku'] = $data['total_sku'] + $this->db->select('sum(C) C')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->C;
        $data['total_kg'] = $data['total_kg'] + $this->db->select('sum(kg) kg')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->kg;
        $data['total_cfc'] = $data['total_cfc'] + $this->db->select('sum(cfc) cfc')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->cfc;
        $data['total_bins'] = $data['total_bins'] + $this->db->select('sum(bins) bins')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->bins;
        $data['total_pallet'] = $data['total_pallet'] + $this->db->select('sum(pallet) pallet')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->pallet;
        $data['total_line'] = $data['total_line'] + $this->db->select('sum(line) line')->from('tbl_manpower_team_performance')->where('tbl_manpower_team_performance.superviser_id', $userId)->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->line;
//        last_query();
        $time = array();

        $time[] = $this->db->select('IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS time')->from('tbl_manpower_team_performance')->where('employee_code', $employee->employee_code)->where('date', date('Y-m-d'))->get()->row()->time;
//        last_query();
//        pre($time);
        $time[] = $data['total_time'];
//        pre($time);
        $data['total_time'] = $this->AddPlayTime($time);
//        pre($data['total_time']);
      }

      $highest_total = array();
      $highest_total['total'] = 0;
      $highest_total['employee_name'] = '';

      foreach ($data['all_employees_data'] as $employee_data) {

        $total = $employee_data['total_challans'] + $employee_data['total_qty'] + $employee_data['total_boxes'] + $employee_data['total_sku'];

        if ($highest_total['total'] < $total) {

          $highest_total['total'] = $total;
          $highest_total['employee_name'] = $employee_data['employee_name'];
        }
      }

      $data['best_performer'] = $highest_total['employee_name'];
    }
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report", $this->global, $data, NULL);
  }

  function AddPlayTime($times) {
    $minutes = 0;

    foreach ($times as $time) {
      list($hour, $minute) = explode(':', $time);
      $minutes += $hour * 60;
      $minutes += $minute;
    }

    $hours = floor($minutes / 60);
    $minutes -= $hours * 60;

// returns the time already formatted
    return sprintf('%02d:%02d', $hours, $minutes);
  }

  function get_employees_to_be_added_table_markup() {
    $employeeDeptId = $this->session->userdata('department_id');
    $query = '
        SELECT
            U.userId AS user_id,
            U.name AS employee_name,
            U.email AS employee_email,
            U.emp_id AS employee_id,
            U.emp_code AS employee_code,
            U.designation AS designation,
            (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS employee_department,
            (SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) As TeamMemberCount
        FROM
            tbl_users AS U
        WHERE
              U.roleId = \'3\' AND isDeleted = 0 AND U.organization_id = \'' . $this->organization_id . '\'

			AND
                (
        ';

    if ($this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_email_filter') == '' && $this->input->post('employee_code_filter') == '' && $this->input->post('employee_department_filter') == '') {

      $query .= ' 1=1 ';
    }

    $first_inner_filter = false;

    if ($this->input->post('employee_name_id_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      } else {

        $query .= '
                AND
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      }
    }

    if ($this->input->post('employee_email_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_code_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_department_filter')) {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      } else {

        $query .= '
                AND
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      }
    }

    $query .= '
            )
            AND
                U.roleId!=1 ORDER BY TeamMemberCount ASC
        ';

//AND(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) = 0
//(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team WHERE date=\''.date('Y-m-d').'\'))=0
    echo $query;

    $all_addable_employees = $this->db->query($query)->result();
    pre($all_addable_employees);

    $return_html = '';

    if ($this->input->post('team_submitted') == 0) {

      $return_html .= '<div class="row"><div class="col-md-7"><h3>Add Team</h3></div> <div class="col-md-3 mt15"></div> <div class="col-md-2 mt15 text-right"><a class="btn btn-primary" href="javascript:void(0)" type="button" data-toggle="modal" data-target="#addorganizationModal" onclick="get_added_employees_table_markup();">Team Preview</a></div></div>';
    } else {

      $return_html .= '<h3>Employees To Add</h3>';
    }

    $return_html .= '<table id="employees_to_add_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';

    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    foreach ($all_addable_employees as $employee) {

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $employee->employee_id . '</td>';
      $return_html .= '<td>' . $employee->employee_code . '</td>';
      $return_html .= '<td>' . $employee->employee_name . '</td>';
      $return_html .= '<td>' . $employee->employee_email . '</td>';
      $return_html .= '<td>' . $employee->designation . '</td>';
      $return_html .= '<td>' . $employee->employee_department . '</td>';

      if ($employee->TeamMemberCount == 0) {

        $return_html .= '<td><button onclick="add_employee_to_team(\'' . $employee->user_id . '\');" type="button" class="btn btn-success">Add</button></td>';
      } else {

        $nwSQl = 'SELECT dept_name FROM tbl_departments WHERE dept_id=(SELECT department_id FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';

        $existindDept = $this->db->query($nwSQl)->row();

        $shiftSql = 'SELECT shift FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1)';

        $existShift = $this->db->query($shiftSql)->row();

        $deptName = ($existindDept) ? $existindDept->dept_name : '';

        $shiftName = ($existShift) ? $existShift->shift : '';

        $Supervisorquery = 'SELECT name,emp_id,emp_code FROM tbl_users WHERE userId = (SELECT created_by FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';
        $SupervisorInfo = $this->db->query($Supervisorquery)->row();
        $supervisorCode = ($SupervisorInfo) ? $SupervisorInfo->emp_code : '';
        $supervisorName = ($SupervisorInfo) ? $SupervisorInfo->name : '';
        $return_html .= '<td><button onclick="javascript:void(0)" type="button" class="btn btn-danger">Added in ' . $deptName . ' - ' . $shiftName . ' - Supervisor Name - ' . $supervisorName . '(' . $supervisorCode . ')</button></td>';
      }


      $return_html .= '</tr>';
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '
        <script>
            $(\'#employees_to_add_table\').DataTable({
                columnDefs: [
                    { "targets": [4], "orderable": false, "searchable": false,"order":[[6,"DESC"]] }
                ],
                info: false,
                searching: true,
                lengthChange: false,
                aaSorting: [[6, "asc"]],
            });
        </script>
        ';

    echo $return_html;
  }

  function getEmployeesToBeAddedTableMarkup() {


    $all_addable_employees = freeToUseEmp();

//pre($all_addable_employees);



    $return_html = '';

    if ($this->input->post('team_submitted') == 0) {

      $return_html .= '<div class="row"><div class="col-md-7"><h3>Add Team</h3></div> <div class="col-md-3 mt15"></div> <div class="col-md-2 mt15 text-right"><a class="btn btn-primary" href="javascript:void(0)" type="button" data-toggle="modal" data-target="#addorganizationModal" onclick="get_added_employees_table_markup();">Team Preview</a></div></div>';
    } else {

      $return_html .= '<div class="row"><div class="col-md-2"> <button style="float:left; margin-top:30px;" onclick="add_employees_to_team();" type="button" class="btn btn-warning">Add</button></div><div class="col-md-10"><h3 style="margin-left:-120px;">Employees To Add</h3></div></div>';
    }

    $return_html .= '<table id="employees_to_add_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th><input class="select_all" onchange="selectAllEmp();" style="height:17px; width:17px; margin-left:10px;"  name="employees_to_add[]" type="checkbox" ></th>';
    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Emp. Code</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    foreach ($all_addable_employees as $employee) {

      $return_html .= '<tr class="odd">';
      $return_html .= '<td><input class="employees_to_add" style="height:17px; width:17px; margin-left:10px;" name="employees_to_add[]" type="checkbox" value="' . $employee->user_id . '"></td>';
      $return_html .= '<td>' . $employee->employee_name . '</td>';
      $return_html .= '<td>' . $employee->designation . '</td>';
      $return_html .= '<td>' . $employee->employee_code . '</td>';
      $return_html .= '<td>' . $employee->employee_email . '</td>';
      if ($employee->TeamMemberCount == 0) {

        $return_html .= '<td><button onclick="add_employee_to_team(\'' . $employee->user_id . '\');" type="button" class="btn btn-success">Add</button></td>';
      } else {

        $nwSQl = 'SELECT dept_name FROM tbl_departments WHERE dept_id=(SELECT department_id FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';

        $existindDept = $this->db->query($nwSQl)->row();

        $shiftSql = 'SELECT shift FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1)';

        $existShift = $this->db->query($shiftSql)->row();

        $deptName = ($existindDept) ? $existindDept->dept_name : '';

        $shiftName = ($existShift) ? $existShift->shift : '';

        $Supervisorquery = 'SELECT name,emp_id,emp_code FROM tbl_users WHERE userId = (SELECT created_by FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';
        $SupervisorInfo = $this->db->query($Supervisorquery)->row();
        $supervisorCode = ($SupervisorInfo) ? $SupervisorInfo->emp_code : '';
        $supervisorName = ($SupervisorInfo) ? $SupervisorInfo->name : '';
        $return_html .= '<td><button onclick="javascript:void(0)" type="button" class="btn btn-danger">Added in ' . $deptName . ' - ' . $shiftName . ' - Supervisor Name - ' . $supervisorName . '(' . $supervisorCode . ')</button></td>';
      }


      $return_html .= '</tr>';
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '
        <script>
            $(\'#employees_to_add_table\').DataTable({
                columnDefs: [
                    { "targets": [4], "orderable": false, "searchable": true,"order":[[6,"DESC"]] }
                ],
                info: false,
                searching: true,
                lengthChange: false,
                aaSorting: [[1, "asc"]],
            });
        </script>
        ';

    echo $return_html;
  }

  function get_free_to_use_employees() {


    $employeeDeptId = $this->session->userdata('department_id');
//U.department_id='.$employeeDeptId.' AND U.roleId = \'3\'
//$this->session->set_userdata($sessionArray);
    $query = '
        SELECT
            U.userId AS user_id,
            U.name AS employee_name,
            U.email AS employee_email,
            U.emp_id AS employee_id,
            U.emp_code AS employee_code,
            U.designation AS designation,
            (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS employee_department,
            (SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) As TeamMemberCount
        FROM
            tbl_users AS U
        WHERE
              U.roleId = \'3\' AND isDeleted = 0 AND U.organization_id = \'' . $this->organization_id . '\'

			AND
                (
        ';

    if ($this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_name_id_filter') == '' && $this->input->post('employee_email_filter') == '' && $this->input->post('employee_code_filter') == '' && $this->input->post('employee_department_filter') == '') {

      $query .= ' 1=1 ';
    }

    $first_inner_filter = false;

    if ($this->input->post('employee_name_id_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      } else {

        $query .= '
                AND
                (
                    U.emp_id LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                OR
                    U.name LIKE \'%' . $this->input->post('employee_name_id_filter') . '%\'
                )
                ';
      }
    }

    if ($this->input->post('employee_email_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.email LIKE \'%' . $this->input->post('employee_email_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_code_filter') != '') {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      } else {

        $query .= '
                AND
                    U.emp_code LIKE \'%' . $this->input->post('employee_code_filter') . '%\'
                ';
      }
    }

    if ($this->input->post('employee_department_filter')) {

      if (!$first_inner_filter) {

        $first_inner_filter = true;

        $query .= '
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      } else {

        $query .= '
                AND
                    U.department_id=\'' . $this->input->post('employee_department_filter') . '\'
                ';
      }
    }

    $query .= '
            )
            AND
                U.roleId!=1 ORDER BY TeamMemberCount ASC
        ';

//AND(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team)) = 0
//(SELECT COUNT(id) FROM tbl_manpower_team_members WHERE employee_id=U.userId AND manpower_team_id IN (SELECT id FROM tbl_manpower_team WHERE date=\''.date('Y-m-d').'\'))=0


    $all_addable_employees = $this->db->query($query)->result();

    $return_html = '';

    if ($this->input->post('team_submitted') == 0) {

      $return_html .= '<div class="row"><div class="col-md-7"><h3>Add Team</h3></div> <div class="col-md-3 mt15"></div> <div class="col-md-2 mt15 text-right"><a class="btn btn-primary" href="javascript:void(0)" type="button" data-toggle="modal" data-target="#addorganizationModal" onclick="get_added_employees_table_markup();">Team Preview</a></div></div>';
    } else {

      $return_html .= '<h3>Employees To Add</h3> ';
    }

    $return_html .= '<table id="employees_to_add_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';

    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</tr>';
    $return_html .= '</thead>';
    $return_html .= '<tbody>';

    foreach ($all_addable_employees as $employee) {
//pre($employee);

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $employee->employee_id . '</td>';
      $return_html .= '<td>' . $employee->employee_code . '</td>';
      $return_html .= '<td>' . $employee->employee_name . '</td>';
      $return_html .= '<td>' . $employee->employee_email . '</td>';
      $return_html .= '<td>' . $employee->designation . '</td>';
      $return_html .= '<td>' . $employee->employee_department . '</td>';

      if ($employee->TeamMemberCount == 0) {

        $return_html .= '<td><button onclick="add_employee_to_team(\'' . $employee->user_id . '\');" type="button" class="btn btn-success">Add</button></td>';
      } else {

        $nwSQl = 'SELECT dept_name FROM tbl_departments WHERE dept_id=(SELECT department_id FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';

        $existindDept = $this->db->query($nwSQl)->row();

        $shiftSql = 'SELECT shift FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1)';

        $existShift = $this->db->query($shiftSql)->row();

        $deptName = ($existindDept) ? $existindDept->dept_name : '';

        $shiftName = ($existShift) ? $existShift->shift : '';

        $Supervisorquery = 'SELECT name,emp_id,emp_code FROM tbl_users WHERE userId = (SELECT created_by FROM tbl_manpower_team WHERE id = (SELECT manpower_team_id FROM tbl_manpower_team_members WHERE employee_id = \'' . $employee->employee_id . '\' ORDER BY id DESC limit 1))';
        $SupervisorInfo = $this->db->query($Supervisorquery)->row();
        $supervisorCode = ($SupervisorInfo) ? $SupervisorInfo->emp_code : '';
        $supervisorName = ($SupervisorInfo) ? $SupervisorInfo->name : '';
        $return_html .= '<td><button onclick="javascript:void(0)" type="button" class="btn btn-danger">Added in ' . $deptName . ' - ' . $shiftName . ' - Supervisor Name - ' . $supervisorName . '(' . $supervisorCode . ')</button></td>';
      }


      $return_html .= '</tr>';
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '
        <script>
            $(\'#employees_to_add_table\').DataTable({
                columnDefs: [
                    { "targets": [4], "orderable": false, "searchable": false,"order":[[6,"DESC"]] }
                ],
                info: false,
                searching: true,
                lengthChange: false,
                aaSorting: [[6, "asc"]],
            });
        </script>
        ';

    echo $return_html;
  }

  function add_employee_to_team() {
    $insert_data = array(
      'manpower_team_id' => $this->input->post('team_id'),
      'employee_id' => $this->input->post('employee_id')
    );
    $this->db->insert('tbl_manpower_team_members', $insert_data);
    echo 'success';
  }

  function addEmployeeToTeam() {
    $empId = $this->input->post('employee_id');
    $departmentByUserArray = departmentByUser($this->session->userdata('userId'));
//pre($departmentByUserArray);
    $ftuDepartmentArray = utfDepartmentByOrg();
//pre($departmentArray);


    if (isEmpInFTUAlreadyToday($empId, $ftuDepartmentArray)) {
//      echo 'true';
//      die;
      $update_data_log = array(
        'user_id' => $empId,
        'org_id' => $this->session->userdata('organization_id'),
        'superviser_id' => $this->session->userdata('userId'),
//              'client_id' => $client_id,
        'dept_id' => $ftuDepartmentArray['dept_id'],
        'sub_dept_id' => $ftuDepartmentArray['id'],
        'shift_id' => $this->input->post('shift_id'),
        'check_out' => date("Y-m-d H:i:s"),
        'status' => '4'
      );
      $this->db->where('user_id', $empId);
//      $this->db->where('client_id', $client_id);
      $this->db->where('dept_id', $ftuDepartmentArray['dept_id']);
      $this->db->where('sub_dept_id', $ftuDepartmentArray['id']);
      $this->db->where('org_id', $this->session->userdata('organization_id'));
//      $this->db->where('shift_id', $shift);
//      $this->db->where('superviser_id', $supervisorId);
      $this->db->where('status', '3');
//      pre($update_data_log);
      $isUpdated = $this->db->update('working_logs', $update_data_log);
    }

    if ($this->role == '4' && $ftuDepartmentArray['id']) {

      $empId = $this->input->post('employee_id');
      $update_data = array(
        'reporting_manager' => $this->session->userdata('userId'),
        'organization_id' => $this->session->userdata('organization_id'),
        'client_id' => $this->input->post('client_id'),
        'department_id' => $this->input->post('dept_id'),
        'sub_department_id' => $this->input->post('sub_dept_id'),
        'shift' => $this->input->post('shift_id'),
        'current_status' => '1',
      );
//      pre($update_data);
      $this->db->where('userId', $empId);
      if ($this->db->update('tbl_users', $update_data)) {
//        $update_data_log = array(
//            'check_out' => date("Y-m-d h:i:s"),
//            'status' => '0',
//        );
//        $this->db->where('user_id', $empId);
//        $this->db->where('status', '1');
//        $this->db->update('working_logs', $update_data_log);
        $insert_data = array(
          'user_id' => $empId,
          'org_id' => $this->session->userdata('organization_id'),
//            'client_id' => $this->input->post('client_id'),
          'superviser_id' => $this->session->userdata('userId'),
          'client_id' => $this->input->post('client_id'),
          'dept_id' => $this->input->post('dept_id'),
          'sub_dept_id' => $this->input->post('sub_dept_id'),
          'shift_id' => $this->input->post('shift_id'),
          'check_in' => date("Y-m-d H:i:s"),
          'status' => '1'
        );
        $this->db->insert('working_logs', $insert_data);
      }
      echo json_encode('success');
    } else {

      echo json_encode('fail');
    }
  }

  function addEmployeeToTeamm() {
    $allIds = $this->input->post('alluserids');
    foreach ($allIds as $key => $value) {
//      pre($value);
      $empId = $value;
//      die;
      $departmentByUserArray = departmentByUser($this->session->userdata('userId'));
//pre($departmentByUserArray);
      $ftuDepartmentArray = utfDepartmentByOrg();
//pre($departmentArray);


      if (isEmpInFTUAlreadyToday($empId, $ftuDepartmentArray)) {
//      echo 'true';
//      die;
        $update_data_log = array(
          'user_id' => $empId,
          'org_id' => $this->session->userdata('organization_id'),
          'superviser_id' => $this->session->userdata('userId'),
//              'client_id' => $client_id,
          'dept_id' => $ftuDepartmentArray['dept_id'],
          'sub_dept_id' => $ftuDepartmentArray['id'],
          'shift_id' => $this->input->post('shift_id'),
          'check_out' => date("Y-m-d H:i:s"),
          'status' => '4'
        );
        $this->db->where('user_id', $empId);
//      $this->db->where('client_id', $client_id);
        $this->db->where('dept_id', $ftuDepartmentArray['dept_id']);
        $this->db->where('sub_dept_id', $ftuDepartmentArray['id']);
        $this->db->where('org_id', $this->session->userdata('organization_id'));
//      $this->db->where('shift_id', $shift);
//      $this->db->where('superviser_id', $supervisorId);
        $this->db->where('status', '3');
//      pre($update_data_log);
        $isUpdated = $this->db->update('working_logs', $update_data_log);
      }

      if ($this->role == '4' && $ftuDepartmentArray['id']) {

//        $empId = $this->input->post('employee_id');
        $update_data = array(
          'organization_id' => $this->session->userdata('organization_id'),
          'client_id' => $this->input->post('client_id'),
          'department_id' => $this->input->post('dept_id'),
          'sub_department_id' => $this->input->post('sub_dept_id'),
          'shift' => $this->input->post('shift_id'),
          'reporting_manager' => $this->session->userdata('userId'),
          'current_status' => '1',
        );
//      pre($update_data);
        $this->db->where('userId', $empId);
        if ($this->db->update('tbl_users', $update_data)) {
//        $update_data_log = array(
//            'check_out' => date("Y-m-d h:i:s"),
//            'status' => '0',
//        );
//        $this->db->where('user_id', $empId);
//        $this->db->where('status', '1');
//        $this->db->update('working_logs', $update_data_log);
          $insert_data = array(
            'user_id' => $empId,
            'org_id' => $this->session->userdata('organization_id'),
//            'client_id' => $this->input->post('client_id'),
            'superviser_id' => $this->session->userdata('userId'),
            'client_id' => $this->input->post('client_id'),
            'dept_id' => $this->input->post('dept_id'),
            'sub_dept_id' => $this->input->post('sub_dept_id'),
            'shift_id' => $this->input->post('shift_id'),
            'check_in' => date("Y-m-d H:i:s"),
            'status' => '1'
          );
          $this->db->insert('working_logs', $insert_data);
        }
      }
    }
    echo json_encode('success');
  }

  function remove_employee_from_team() {

    if ($this->role == '4') {
      $this->db->where('employee_id', $this->input->post('employee_id'))
          ->where('manpower_team_id', $this->input->post('team_id'))
          ->delete('tbl_manpower_team_members');

      echo json_encode('success');
    } else {

      echo json_encode('fail');
    }
  }

  function removeEmployeeFromTeam() {
//pre($this->session->userdata());

    $empId = $this->input->post('employee_id');
    $client_id = $this->input->post('client_id');
    $dept_id = $this->input->post('dept_id');
    $sub_dept_id = $this->input->post('sub_dept_id');
    $shift = $this->input->post('shift');
//    $currentStatus = $this->input->post('current_satus');


    $supervisorId = $this->session->userdata('userId');
    $departmentArray = utfDepartmentByOrg();
    if ($this->role == '4' && $departmentArray['id']) {
      $empId = $this->input->post('employee_id');
      $update_data = array(
        'sub_department_id' => $departmentArray['id'],
        'department_id' => $departmentArray['dept_id'],
        'reporting_manager' => null,
        'current_status' => '0',
      );
      $this->db->where('userId', $empId);
      if ($this->db->update('tbl_users', $update_data)) {

        $update_data_log = array(
          'check_out' => date("Y-m-d H:i:s"),
          'client_id' => $client_id,
          'dept_id' => $dept_id,
          'sub_dept_id' => $sub_dept_id,
          'shift_id' => $shift,
          'superviser_id' => $supervisorId,
          'org_id' => $this->session->userdata('organization_id'),
          'status' => '2',
        );
        $this->db->where('user_id', $empId);
        $this->db->where('client_id', $client_id);
        $this->db->where('dept_id', $dept_id);
        $this->db->where('sub_dept_id', $sub_dept_id);
        $this->db->where('shift_id', $shift);
        $this->db->where('superviser_id', $supervisorId);
        $this->db->where('org_id', $this->session->userdata('organization_id'));
        $this->db->where('status', '1');
        $isUpdated = $this->db->update('working_logs', $update_data_log);
        if ($isUpdated) {
//          pre($departmentByUserArray);
          $insert_data = array(
            'user_id' => $empId,
            'org_id' => $this->session->userdata('organization_id'),
            'superviser_id' => $this->session->userdata('userId'),
//              'client_id' => $client_id,
            'dept_id' => $departmentArray['dept_id'],
            'sub_dept_id' => $departmentArray['id'],
            'shift_id' => $shift,
            'check_in' => date("Y-m-d H:i:s"),
            'status' => '3'
          );
          $this->db->insert('working_logs', $insert_data);
        }
//        $departmentByUserArray = departmentByUser($supervisorId);
      }
      echo json_encode('success');
    } else {
      echo json_encode('fail');
    }
  }

  function leaveEmployeeFromTeam() {
//    echo "hhhhh";
//    die;
    $departmentArray = utfDepartmentByOrg();
    if ($this->role == '4' && $departmentArray['id']) {


      $empId = $this->input->post('employee_id');
      $client_id = $this->input->post('client_id');
      $dept_id = $this->input->post('dept_id');
      $sub_dept_id = $this->input->post('sub_dept_id');
      $shift = $this->input->post('shift');
      $currentStatus = $this->input->post('current_satus');

//      pre($currentStatus, FALSE);
      $update_data = array(
        'current_status' => $currentStatus,
      );
      $this->db->where('userId', $empId);
      if ($this->db->update('tbl_users', $update_data)) {
        if (in_array($currentStatus, ['2', '3'])) {
          $this->db->where('user_id', $empId);
          $this->db->where('client_id', $client_id);
          $this->db->where('dept_id', $dept_id);
          $this->db->where('sub_dept_id', $sub_dept_id);
          $this->db->where('shift_id', $shift);
          $this->db->like('created_at', date('Y-m-d'), 'after');
          $this->db->delete('working_logs');
        }
      }
      echo json_encode('success');
    } else {
      echo json_encode('fail');
    }
  }

  function get_added_employees_table_markup() {

    $userId = $this->session->userdata('userId');

    $all_departments = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();

    $clientClist = $this->db->from('tbl_clients')->get()->result();

    $searchString = ',';
    if (is_array($this->input->post('client'))) {
      $clientName = implode(',', $this->input->post('client'));
    } else {
      $clientName = $this->input->post('client');
    }



    $current_team_id = $this->db->select('id')
            ->from('tbl_manpower_team')
            ->where('department_id', $this->input->post('department_id'))
            ->where('shift', $this->input->post('shift'))
//->where('created_by',$userId)
//->where('client', $clientName)
            ->limit(1)
            ->order_by('date', 'DESC')
            ->get()->row()->id;
//echo $current_team_id; die;




    $teamshift = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $current_team_id)->get()->row()->shift;

//$all_team_employees = $this->db->query('SELECT U.roleId AS user_role, U.userId AS user_id, U.name AS employee_name, U.email AS employee_email, U.emp_id AS employee_id, U.emp_code AS employee_code,U.department_id,(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name FROM tbl_users AS U WHERE U.userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE manpower_team_id=(SELECT id FROM tbl_manpower_team WHERE department_id='.$this->input->post('department_id').' AND shift=\''.$this->input->post('shift').'\' AND client=\''.$clientName.'\' AND date=\''.date('Y-m-d').'\'))')->result();


    /*     * ***Old** */
    /* $all_team_employees = $this->db->query('SELECT U.roleId AS user_role,U.designation, U.userId AS user_id, U.name AS employee_name, U.email AS employee_email, U.emp_id AS employee_id, U.emp_code AS employee_code,U.department_id,(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name FROM tbl_users AS U WHERE U.userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=(SELECT id FROM tbl_manpower_team WHERE created_by = '.$userId.' AND department_id='.$this->input->post('department_id').' AND shift=\''.$this->input->post('shift').'\'))')->result(); */

    $all_team_employees = $this->db->query('SELECT U.roleId AS user_role,U.designation, U.userId AS user_id, U.name AS employee_name, U.email AS employee_email, U.emp_id AS employee_id, U.emp_code AS employee_code,U.department_id,(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name FROM tbl_users AS U WHERE U.userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=(SELECT id FROM tbl_manpower_team WHERE department_id=' . $this->input->post('department_id') . ' AND shift=\'' . $this->input->post('shift') . '\'))')->result();

    $return_html = '<h3>Team Members</h3>';
    $return_html .= '<table id="added_employees_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Emp. ID</th>';
    $return_html .= '<th>Emp. Code</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Department</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '</ tr>';
    $return_html .= '</head>';
    $return_html .= '<tbody>';

    foreach ($all_team_employees as $team_employee) {

      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $team_employee->employee_name . '</td>';
      $return_html .= '<td>' . $team_employee->employee_id . '</td>';
      $return_html .= '<td>' . $team_employee->employee_code . '</td>';
      $return_html .= '<td>' . $team_employee->designation . '</td>';
      $return_html .= '<td>' . $team_employee->employee_email . '</td>';
      $return_html .= '<td>' . $team_employee->department_name . '</td>';

      $empUserId = $team_employee->user_id;
//$current_team_id

      $shiftInfo = $this->db->select('shift_date,shift_status,shift_over')->from('tbl_manpower_team_members')->where('manpower_team_id', $current_team_id)->where('employee_id', $empUserId)->get()->row();
      $shiftStatus = $shiftInfo->shift_status;

      if ($this->input->post('from_view_team_page') == 'true' || ($userId == $team_employee->user_id) || $team_employee->user_role == '4') {
        $overHtml = '';
        if ($shiftStatus == '1') {
          $overHtml = '<button class="btn btn-info btn-xs" onclick="shiftOver(\'' . $empUserId . '\',\'' . $current_team_id . '\')">Shift Over</button>';
        }

        $return_html .= '
                <td>
                    <button style="display:none" type="button" class="btn btn-success" data-toggle="modal" onclick="$(\'#shift_team_employee_id\').val(\'' . $team_employee->user_id . '\'); $(\'#shift_team_time_hour\').val(\'\'); $(\'#shift_team_time_minute\').val(\'\');" data-target="#shift_team_modal">Shift Member</button>
                ' . $overHtml . '</td>';
      } else {



        /* $chkshift = $this->db->select('id')->where('manpower_team_id',$current_team_id)->where('employee_id',$empUserId)->where("shifted_manpower_team_id","0")->where("shift_over","0")->where("return_status","0")->where('shift_date',date('Y-m-d'))->order_by('id','DESC')->limit(1)->get('tbl_manpower_team_members')->num_rows(); */

        $chkshift = $this->db->select('id')->where('employee_id', $empUserId)->where("shifted_manpower_team_id", "0")->where("shift_status", "1")->where("shift_over", "0")->where('shift_date', date('Y-m-d'))->limit(1)->get('tbl_manpower_team_members')->num_rows();

        if ($shiftStatus == '1' || $chkshift != 0) {
          $return_html .= '
                            <td>
                                <button type="button" onclick="remove_employee_from_team(\'' . $team_employee->user_id . '\');" class="btn btn-danger"><i class="fa fa-trash"></i></button>
                             </td>';
        } else {


          $return_html .= '
                    <td>
                        <button type="button" onclick="remove_employee_from_team(\'' . $team_employee->user_id . '\');" class="btn btn-danger"><i class="fa fa-trash"></i></button>
                        <button type="button" class="btn btn-success" data-toggle="modal" onclick="$(\'#shift_team_employee_id\').val(\'' . $team_employee->user_id . '\'); $(\'#shift_team_time_hour\').val(\'\'); $(\'#shift_team_department\').val(\'\'); $(\'#shift_team_shift\').val(\'\'); $(\'#shift_team_client\').val(\'\'); $(\'#response_message_div\').html(\'\');  $(\'#shift_team_time_minute\').val(\'\');" data-target="#shift_team_modal">Shift Member</button>
                    </td>';
        }
      }

      $return_html .= '</tr>';
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    /* $return_html .= '
      <div id="shift_team_modal123" class="modal fade" role="dialog">
      <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content">
      <div class="modal-header">
      <button type="button" class="close" onclick="$(\'#shift_team_modal\').modal(\'hide\');">&times;</button>
      <h4 class="modal-title">Shift Team</h4>
      </div>
      <div class="modal-body">
      <div class="row">
      <div class="col-xs-12">

      <div id="response_message_div"></div>

      <input type="hidden" id="shift_team_employee_id">

      <div class="form-group" id="shift_team_department_div">
      <label class="control-label">Select Department <sup>*<sup></label>
      <span class="help-block" id="shift_team_department_error"></span>
      <select id="shift_team_department" name="department" class="form-control">
      <option value="">--Select--</option>';

      foreach ($all_departments as $department) {

      $return_html .= '<option value="'.$department->dept_id.'">'.$department->dept_name.'</option>';
      }

      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_shift_div">
      <label class="control-label">Select Shift <sup>*</sup></label>
      <span class="help-block" id="shift_team_shift_error"></span>
      <select class="form-control" id="shift_team_shift" name="shift">
      <option value="">--Select--</option>';
      if($teamshift != ''){
      $return_html .= '<option value="'.$teamshift.'">'.$teamshift.'</option>';
      }
      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_client_div">
      <label class="control-label">Select Client <sup>*</sup></label>
      <span class="help-block" id="shift_team_client_error"></span>
      <select class="form-control" id="shift_team_client" name="client">

      <option value="">--Select--</option>
      ';
      if(!empty($clientClist)){
      foreach ($clientClist as $client){
      $return_html .= '<option value="'.$client->client.'">'.$client->client.'</option>';
      }
      }
      $return_html .= '</select>
      </div>
      <div class="form-group" id="shift_team_time_div">
      <label class="control-label">Select Time</label>
      <span class="help-block" id="shift_team_time_error"></span>
      <select class="form-control" id="shift_team_time_hour" style="float: left; width: 30%;">
      <option value="">--Select--</option>
      <option value="01">01</option>
      <option value="02">02</option>
      <option value="03">03</option>
      <option value="04">04</option>
      <option value="05">05</option>
      <option value="06">06</option>
      <option value="07">07</option>
      <option value="08">08</option>
      <option value="09">09</option>
      <option value="10">10</option>
      <option value="11">11</option>
      <option value="12">12</option>
      <option value="13">13</option>
      <option value="14">14</option>
      <option value="15">15</option>
      <option value="16">16</option>
      <option value="17">17</option>
      <option value="18">18</option>
      <option value="19">19</option>
      <option value="20">20</option>
      <option value="21">21</option>
      <option value="22">22</option>
      <option value="23">23</option>
      <option value="24">24</option>
      </select>

      <span style="float:left; text-align: center; width: 5%;"> : </span>

      <select class="form-control" id="shift_team_time_minute" style="width: 30%; float: left">
      <option value="">--Select--</option>
      <option value="00">00</option>
      <option value="05">05</option>
      <option value="10">10</option>
      <option value="15">15</option>
      <option value="20">20</option>
      <option value="25">25</option>
      <option value="30">30</option>
      <option value="35">35</option>
      <option value="40">40</option>
      <option value="45">45</option>
      <option value="50">50</option>
      <option value="55">55</option>
      </select>

      <div style="clear:both;"></div>
      </div>
      <div class="form-group">
      <button type="button" class="btn btn-success" onclick="submit_shift_team_request();">Submit Request</button>
      </div>
      </div>
      </div>
      </div>
      <div class="modal-footer">
      <button type="button" class="btn btn-default" onclick="$(\'#shift_team_modal\').modal(\'hide\');">Close</button>
      </div>
      </div>
      </div>
      </div>';
     */


    echo $return_html;
  }

  function getAddedEmployeesTableMarkup() {
    $disabled = " ";
    $disabledTest = "Leave";

//    pre($this->input->post());
//    $userId = $this->session->userdata('userId');
//    $departmentId = $this->session->userdata('department_id');
//    $subDepartmentId = $this->session->userdata('sub_department_id');
//    $orgId = $this->session->userdata('organization_id');
//    $selectQuery = 'SELECT '
//            . '  '
//            . 'U.roleId AS user_role,'
//            . 'U.designation, '
//            . 'U.userId AS user_id, '
//            . 'U.name AS employee_name, '
//            . 'U.email AS employee_email, '
//            . 'U.emp_id AS employee_id, '
//            . 'U.emp_code AS employee_code,'
//            . 'U.department_id, U.current_status, '
//            . '(SELECT dept_name from `tbl_departments` where `dept_id`= department_id) as department_name, '
//            . '(SELECT sub_dept_name from `tbl_sub_departments` where `id`= sub_department_id) as sub_department_name FROM tbl_users AS U '
//            . 'WHERE U.userId != ' . $userId . ' AND U.current_status != 0 AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' and organization_id = ' . $orgId . ' and U. 	roleId  != 4';
//    $all_team_employees = $this->db->query($selectQuery)->result();
    $all_team_employees = isEmployeeInTeam($this->input->post());
//    pre($all_team_employees);
    $return_html = '<h3>Team Members</h3>';
    $return_html .= '<table id="added_employees_table" class="table table-striped listingtable">';
    $return_html .= '<thead>';
    $return_html .= '<tr class="listingtable-head">';
    $return_html .= '<th>Name</th>';
    $return_html .= '<th>Designation</th>';
    $return_html .= '<th>Emp. Code</th>';
    $return_html .= '<th>Email</th>';
    $return_html .= '<th>Actions</th>';
    $return_html .= '<th>Status</th>';
    $return_html .= '</ tr>';
    $return_html .= '</head>';
    $return_html .= '<tbody>';

    foreach ($all_team_employees as $team_employee) {
      $onclickRemove = 'onclick="remove_employee_from_team(\'' . $team_employee->user_id . '\',\'' . $team_employee->client_id . '\',\'' . $team_employee->department_id . '\',\'' . $team_employee->sub_department_id . '\',\'' . $team_employee->shift . '\');"';
      $oncliclLeave = 'onchange="leave_employee_from_team(\'' . $team_employee->user_id . '\',\'' . $team_employee->client_id . '\',\'' . $team_employee->department_id . '\',\'' . $team_employee->sub_department_id . '\',\'' . $team_employee->shift . '\');"';
      if ($team_employee->current_status >= 2) {
        $disabled = " disabled";
        $disabledTest = "On Leave";
        $onclickRemove = '';
      }
      $status_is = ' id="' . $team_employee->user_id . '"';
      $return_html .= '<tr class="odd">';
      $return_html .= '<td>' . $team_employee->employee_name . '</td>';
      $return_html .= '<td>' . $team_employee->designation . '</td>';
      $return_html .= '<td>' . $team_employee->employee_code . '</td>';
      $return_html .= '<td>' . $team_employee->employee_email . '</td>';

      $return_html .= '
                    <td>
                        <button type="button" ' . $onclickRemove . ' class="btn btn-danger' . $disabled . '">Release</button>
                    </td>';
      $return_html .= '
                    <td>
                        <button type="button" class="btn_slt">
                           <select ' . $oncliclLeave . $status_is . ' class="form-control">';
      if ($team_employee->current_status == '1') {
        $return_html .= '  <option value = "1" selected>Present</option>';
      } else {
        $return_html .= '  <option value = "1">Present</option>';
      }
      if ($team_employee->current_status == '2') {
        $return_html .= '  <option value = "2" selected>Absent</option>';
      } else {
        $return_html .= '  <option value = "2">Absent</option>';
      }
      if ($team_employee->current_status == '3') {
        $return_html .= '  <option value = "3" selected>On Leave</option>';
      } else {
        $return_html .= '  <option value = "3">On Leave</option>';
      }

      $return_html .= '
          </select>
          </button>

          </td>';

      $return_html .= '</tr>';
      $disabledTest = "Leave";
      $disabled = " ";
    }

    $return_html .= '</tbody>';
    $return_html .= '</table>';

    $return_html .= '
        <script>
            $(\'#added_employees_table\').DataTable({
                columnDefs: [
                    { "targets": [4], "orderable": false, "searchable": false,"order":[[2,"DESC"]] }
                ],
                info: false,
                searching: true,
                lengthChange: false,
                aaSorting: [[2, "asc"]],
            });
        </script>
        ';

    echo $return_html;
  }

  public function update_shift_over() {
    $empId = $this->input->post('empId');
    $teamId = $this->input->post('teamId');

    $this->db->where(['manpower_team_id' => $teamId, 'employee_id' => $empId]);
    $this->db->update('tbl_manpower_team_members', ['shift_over' => '1']);

    /*     * Update main team table */
    $this->db->where(['employee_id' => $empId, 'request_approved' => '1']);
    $this->db->where("shifted_manpower_team_id != '0'");
    $this->db->update('tbl_manpower_team_members', ['return_status' => '1']);

    echo json_encode('shiftupdated');
  }

  public function approve_team_shift($request_token) {

    $shift_request_details = $this->db->select('*')->from('tbl_manpower_team_members')->where('request_token', $request_token)->get()->row();

    $this->db->where('id', $shift_request_details->id)
        ->update('tbl_manpower_team_members', array('request_approved' => 1, 'return_status' => '1'));

    $insert_data['manpower_team_id'] = $shift_request_details->shifted_manpower_team_id;
    $insert_data['employee_id'] = $shift_request_details->employee_id;
    $insert_data['shift_date'] = date('Y-m-d');
    $insert_data['shift_status'] = '1';
    $this->db->insert('tbl_manpower_team_members', $insert_data);

    $this->session->set_flashdata('message', '<div class = "alert alert-success"><b>Success!</b> Shift Change Approved Successfully.</div>');

    redirect('view-team');
  }

  public function check_and_send_shift_team_request() {



    $team_check_query = $this->db->select(array('id', 'created_by'))
        ->from('tbl_manpower_team')
        ->where('department_id', $this->input->post('department_id'))
        ->where('shift', $this->input->post('shift'))
//->where('client', $this->input->post('client'))
// ->where('date', date('Y-m-d'))
        ->where('created_by != ', $this->session->userdata('userId'))
        ->get();

    if ($team_check_query->num_rows()) {

      $new_team_id = $team_check_query->row()->id;

      $new_team_creator_id = $team_check_query->row()->created_by;

      $new_team_creator_email_name = $this->db->select(array('email', 'name'))->from('tbl_users')->where('userId', $new_team_creator_id)->get()->row();

      $current_team_creator_name = $this->db->select('name')->from('tbl_users')->where('userId', $this->session->userdata('userId'))->get()->row()->name;

      $employee_details = $this->db->select('*')->from('tbl_users')->where('userId', $this->input->post('employee_id'))->get()->row();

      $update_data['shift_request_time'] = time();

      $request_token = $update_data['request_token'] = (string) ((int) time() + (int) rand());

      $update_data['shifted_manpower_team_id'] = $new_team_id;

      $update_data['new_shift_start_date_time'] = date('Y-m-d') . ' ' . $this->input->post('shift_team_time_hour') . ':' . $this->input->post('shift_team_time_minute') . ':00';

      $update_data['shift_date'] = date('Y-m-d');

      $update_data['return_status'] = '0';

      $this->db->where('manpower_team_id', $this->input->post('current_team_id'))
          ->where('employee_id', $this->input->post('employee_id'))
          ->update('tbl_manpower_team_members', $update_data);

      $to = $new_team_creator_email_name->email;
      $subject = 'Employee Team Shift Request';
      $headers = "From: " . strip_tags('support@.com') . "\r\n";
      $headers .= "Reply-To: " . strip_tags('support@.com') . "\r\n";
      $headers .= "MIME-Version: 1.0\r\n";
      $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

      $message = '<p>Hi ' . $new_team_creator_email_name->name . '</p>';
      $message .= '<p>Supervisor ' . $current_team_creator_name . ' has request for the following employee to be shifted to your team :-</p>';
      $message .= '
          <p>
          Employee Name : ' . $employee_details->name . '<br>
          Employee ID : ' . $employee_details->emp_id . '<br>
          Employee Code : ' . $employee_details->emp_code . '<br>
          Employee Designation : ' . $employee_details->designation . '
          </p>
          ';
      $message .= '<p>Please click on this <a href = "' . base_url('approve_team_shift/' . $request_token) . '">link</a> to approve the team shift for the employee.</p>';

      $message .= '<p>Best Regards, <br>Team .</p>';
      $mailData['to'] = $to;
      $mailData['subject'] = $subject;
      $mailData['message'] = $message;

      /*       * *****Send Shift Mail********** */
      sendShiftMemberMail($mailData);
      echo '<div class = "alert alert-success">Request Sent Successfully</div>';
    } else {

      echo '<div class = "alert alert-danger">No team created for given department and shift.</div>';
    }
  }

  protected function getAvialableShift() {
    $userId = $this->session->userdata('userId');
    $result = array();
    $this->db->select('shift');
    $this->db->where('department_id', $this->session->userdata('department_id'));
    $this->db->where("created_by != '" . $userId . "'");
    $this->db->where("shift != ''");
    $this->db->group_by('shift');
    $shiftList = $this->db->get('tbl_manpower_team')->result_array();
    if (!empty($shiftList)) {
      foreach ($shiftList as $shift) {
        $result[] = $shift['shift'];
      }
    }
    return $result;
  }

  /** This function will be useful only for the first time when the supervisor visits the create team page. */
  protected function create_team_and_add_supervisor_if_team_does_not_exist() {
    $userId = $this->session->userdata('userId');
    $departmentDataArray = departmentByUser($userId);
//$shift = $this->session->userdata('shift');
//$shift = shiftNameBySubDeptId($this->session->userdata('sub_department_id'));
    $shift = shiftNameBySupervisor($userId);
//$team_already_exists_query = $this->db->select('id')->from('tbl_manpower_team')->where('created_by',$userId)->where('department_id', $this->session->userdata('department_id'))->where('date', date('Y-m-d'))->get();
    /* $team_already_exists_query = $this->db->select('id')->from('tbl_manpower_team')->where('created_by',$userId)->where('department_id', $this->session->userdata('department_id'))->limit(1)->order_by('date','DESC')->get(); */
    $team_already_exists_query = $this->db->select('id')->from('tbl_manpower_team')->where('shift', $shift)->where('department_id', $departmentDataArray['dept_id'])->limit(1)->order_by('date', 'DESC')->get();
//last_query();
    if (!$team_already_exists_query->num_rows()) {
      $insert_data = array(
        'department_id' => $departmentDataArray['department_id'],
        'shift' => $shift,
        'client' => '',
        'date' => date('Y-m-d'),
        'creation_time' => time(),
        'created_by' => $this->session->userdata('userId')
      );
      $this->db->insert('tbl_manpower_team', $insert_data);
      $team_id = $this->db->insert_id();
      $insert_data = array(
        'manpower_team_id' => $team_id,
        'employee_id' => $this->session->userdata('userId')
      );
      $this->db->insert('tbl_manpower_team_members', $insert_data);
      return $team_id;
    } else {

      $this->db->where('id', $team_already_exists_query->row()->id);
      $this->db->update('tbl_manpower_team', ['shift' => $shift]);

      return $team_already_exists_query->row()->id;
    }
  }

  function save_shift_post() {
    $update_data['shift'] = $this->input->post('shift');
    $this->db->where('id', $this->input->post('team_id'));
    $this->db->update('tbl_manpower_team', $update_data);
    $this->session->set_flashdata('message', '<div class = "alert alert-success"><b>Success!</b> Shift Saved Successfully.</div>');
    redirect('create-team');
  }

  function save_client_post() {
    $clients = implode(",", $this->input->post('client'));
    $update_data['client'] = $clients;
    $this->db->where('id', $this->input->post('team_id'));
    $this->db->update('tbl_manpower_team', $update_data);
    $this->session->set_flashdata('message', '<div class = "alert alert-success"><b>Success!</b> Client Saved Successfully.</div>');
    redirect('create-team');
  }

  function view_manager_team() {
    $userId = $this->session->userdata('userId');
    $departmentId = $this->session->userdata('department_id');
    $orgId = $this->session->userdata('organization_id');
    if ($this->role != 2 && $this->role != 8) {
      $this->loadThis();
    } else {
      $this->db->select('id, shift');
      $this->db->where('department_id', $departmentId);
      $this->db->where('team_submitted', '1');
      $teamList = $this->db->get('tbl_manpower_team')->result_array();
      $data['teamList'] = $teamList;
      $warehouseList = $this->user_model->getOrganizationList($orgId);
      $data['warehouseList'] = $warehouseList;
      $data['department_id'] = $departmentId;
      $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();
      $data['departmentList'] = $this->user_model->getDepartmentList($orgId);
      $data['role'] = $this->role;
      $this->loadViews("manpower_view_team_new", $this->global, $data, NULL);
    }
  }

  function getDepartmentShift() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $deptId = $this->input->post('deptId');
    $this->db->select('id, shift');
    $this->db->where('team_submitted', '1');
    $this->db->where('department_id', $deptId);
    $result = $this->db->get('tbl_manpower_team')->result_array();
    echo json_encode($result);
    exit;
  }

  function getRequestEmployeeList() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $organization_id = $this->session->userdata('organization_id');
    $department_id = $this->session->userdata('department_id');
    $shift = $this->session->userdata('shift');
    if ($this->input->post('shift')) {
      $shift = $this->input->post('shift');
    }
    $this->db->select('created_by');
    $this->db->where(['department_id' => $department_id, 'shift' => $shift, 'team_submitted' => '1']);
    $created_by = $this->db->get('tbl_manpower_team')->row()->created_by;
    $this->db->select('id');
    $this->db->where('department_id', $department_id);
    $this->db->where('shift', $shift);
    $this->db->where('team_submitted', '1');
    $this->db->where('created_by', $created_by);
    $teamId = $this->db->get('tbl_manpower_team')->row()->id;
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $this->db->where('shifted_manpower_team_id', $teamId);
    $this->db->where('shift_date', date('Y-m-d'));
    $this->db->from('tbl_manpower_team_members');
    $this->db->join('tbl_users', 'tbl_users.userId = tbl_manpower_team_members.employee_id');
    $this->db->join('tbl_manpower_team', 'tbl_manpower_team.id = tbl_manpower_team_members.manpower_team_id');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_users.department_id');
    $totalrows = $this->db->get()->num_rows();
    $this->db->select('tbl_users.name, tbl_users.emp_code, tbl_users.designation, tbl_departments.dept_name, tbl_manpower_team.shift, tbl_manpower_team_members.shift_date, tbl_manpower_team_members.request_approved, tbl_manpower_team_members.return_status, tbl_manpower_team_members.request_token');
    $this->db->where('shifted_manpower_team_id', $teamId);
    $this->db->where('shift_date', date('Y-m-d'));
    $this->db->from('tbl_manpower_team_members');
    $this->db->join('tbl_users', 'tbl_users.userId = tbl_manpower_team_members.employee_id');
    $this->db->join('tbl_manpower_team', 'tbl_manpower_team.id = tbl_manpower_team_members.manpower_team_id');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_users.department_id');
    $this->db->limit($length, $start);
    $query = $this->db->get();
    $filterrecord = $query->num_rows();
    $results = $query->result_array();
    $data = array();
    if (!empty($results)) {
      foreach ($results as $key => $val) {
        $attr = array();
        $attr[] = $val['name'];
        $attr[] = $val['emp_code'];
        $attr[] = $val['designation'];
        $attr[] = $val['dept_name'];
        $attr[] = $val['shift'];
        $attr[] = date('d-m-Y', strtotime($val['shift_date']));
        if ($val['request_approved'] == '1' && $val['return_status'] == '1') {
          $attr[] = 'Approved';
        } else {
          $attr[] = "<a class='btn btn-danger' href='" . site_url('approve_team_shift/' . $val['request_token']) . "'>Pending</a>";
        }
        $data[] = $attr;
      }
    }
    $output = array(
      "draw" => $draw,
      "recordsTotal" => $totalrows,
      "recordsFiltered" => $filterrecord,
      "data" => $data
    );
    echo json_encode($output);
    exit();
  }

  function shiftRequest() {
    if ($this->role != 4 && $this->role != 2 && $this->role != 8) {
      $this->loadThis();
    } else {
      if ($this->role == 2) {
        $department_id = $this->session->userdata('department_id');
        $this->db->select('shift');
        $this->db->where('department_id', $department_id);
        $this->db->where('team_submitted', '1');
        $data['shiftList'] = $this->db->get('tbl_manpower_team')->result_array();
      }
      $this->loadViews("manpower_shift_request", $this->global, $data, NULL);
    }
  }

  function view_team() {
    $userId = $this->session->userdata('userId');
    $shift = $this->session->userdata('shift');
    /** Checking if supervisor exists in the current date team and if not, then adding him to the team. */
    $data['team_id'] = $this->create_team_and_add_supervisor_if_team_does_not_exist();
    $data['team_shift'] = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift;
    $data['team_client'] = $this->db->select('client')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->client;
    $data['shift_start_time'] = $this->db->select('shift_start_time')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift_start_time;
    $data['team_submitted'] = $this->db->select('team_submitted')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->team_submitted;
//$team_id_query = $this->db->select(array('id', 'shift', 'client'))->from('tbl_manpower_team')->where('created_by',$userId)->where('department_id', $this->session->userdata('department_id'))->where('date', date('Y-m-d'))->get();
    $team_id_query = $this->db->select(array('id', 'shift', 'client'))->from('tbl_manpower_team')->where('shift', $shift)->where('department_id', $this->session->userdata('department_id'))->get();
    if ($team_id_query->num_rows()) {
      $data['team_id'] = $team_id_query->row()->id;
      $data['shift'] = $team_id_query->row()->shift;
      $data['client'] = $team_id_query->row()->client;
    } else {
      $data['team_id'] = 0;
      $data['shift'] = '';
      $data['client'] = '';
    }

    $department_name_query = $this->db->select('dept_name')->from('tbl_departments')->where('dept_id', $this->session->userdata('department_id'))->get();

    if ($department_name_query->num_rows()) {

      $data['department_name'] = $department_name_query->row()->dept_name;
    } else {

      $data['department_name'] = '';
    }
    $this->loadViews("manpower_view_team", $this->global, $data, NULL);
  }

  function upload_team_report($team_id) {
    $this->global['pageTitle'] = 'Searbird : Upload Team Report';
//    pre($this->session->userdata('client_id'));
    $data['team_id'] = $team_id;
    $data['clientList'] = $this->user_model->getClientByClientId($this->session->userdata('client_id'));

//    $data['clientList'] = clientsListArray($this->session->userdata('userId'), $type = 'array');
    $data['departmentList'] = departmentList($this->session->userdata('userId'), $type = 'array');
//    pre($data);
    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    $data['role'] = $this->role;
    $this->loadViews("upload_team_report", $this->global, $data, NULL);
  }

  function upload_team_report_co($team_id) {
    $this->global['pageTitle'] = 'Searbird : Upload Team Report';
//    pre($this->session->userdata('client_id'));
    $data['team_id'] = $team_id;
    $data['clientList'] = $this->user_model->getClientByClientId($this->session->userdata('client_id'));

//    $data['clientList'] = clientsListArray($this->session->userdata('userId'), $type = 'array');
    $data['departmentList'] = departmentList($this->session->userdata('userId'), $type = 'array');
//    pre($data);
    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    $data['role'] = $this->role;
    $this->loadViews("upload_team_report_co", $this->global, $data, NULL);
  }

  function submit_team() {

    $update_data['team_submitted'] = 1;
    $this->db->where('id', $this->input->post('team_id'))->update('tbl_manpower_team', $update_data);
    $this->session->set_flashdata('message', '<div class = "alert alert-success">Team has been created!</div>');
    redirect('create-team');
  }

  function save_shift_start_time() {
    $update['shift_start_time'] = date('Y-m-d') . ' ' . $this->input->post('hour') . ':' . $this->input->post('minute') . ':00';
    $this->db->where('id', $this->input->post('team_id'))->update('tbl_manpower_team', $update);
    echo 'Success';
  }

  function edit_team($team_id) {

    $data['team_id'] = $team_id;

    $data['edit_team_invoked'] = true;

    $data['team_submitted'] = $this->db->select('team_submitted')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->team_submitted;

    $data['all_departments'] = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();

    $data['team_shift'] = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift;

    $data['team_client'] = $this->db->select('client')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->client;

    $data['shift_start_time'] = $this->db->select('shift_start_time')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift_start_time;

    $fetch_department_name_query = $this->db->query('SELECT dept_name FROM tbl_departments WHERE dept_id = ' . $this->session->userdata('department_id'));

    if ($fetch_department_name_query->num_rows()) {

      $data['department_name'] = $fetch_department_name_query->row()->dept_name;
    } else {

      $data['department_name'] = '';
    }

    $this->global['pageTitle'] = 'Searbird : Manpower Create Team';
    $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();

    $ordId = $this->session->userdata('organization_id');
    $data['departmentList'] = $this->user_model->getDepartmentList($ordId);

    $this->loadViews("manpower_create_team", $this->global, $data, NULL);
  }

//  function edit_team() {
//
//    $data['team_id'] = $team_id;
//
//    $data['edit_team_invoked'] = true;
//
//    $data['team_submitted'] = $this->db->select('team_submitted')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->team_submitted;
//
//    $data['all_departments'] = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();
//
//    $data['team_shift'] = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift;
//
//    $data['team_client'] = $this->db->select('client')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->client;
//
//
//    $data['shift_start_time'] = $this->db->select('shift_start_time')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift_start_time;
//
//    $fetch_department_name_query = $this->db->query('SELECT dept_name FROM tbl_departments WHERE dept_id = ' . $this->session->userdata('department_id'));
//
//    if ($fetch_department_name_query->num_rows()) {
//
//      $data['department_name'] = $fetch_department_name_query->row()->dept_name;
//    } else {
//
//      $data['department_name'] = '';
//    }
//
//    $this->global['pageTitle'] = 'Searbird : Manpower Create Team';
//    $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();
//
//    $ordId = $this->session->userdata('organization_id');
//    $data['departmentList'] = $this->user_model->getDepartmentList($ordId);
//
//    $this->loadViews("manpower_create_team", $this->global, $data, NULL);
//  }

  function create_team() {
    $userId = $this->session->userdata('userId');

    $deptArray = departmentByUser($userId);

//pre(subDeptIdBySupervisor($userId));
    /** Checking if supervisor exists in the current date team and if not, then adding him to the team. */
    $data['team_id'] = 1;
//    $data['team_id'] = $this->create_team_and_add_supervisor_if_team_does_not_exist();
//    $data['team_id'] = $this->create_team_and_add_supervisor_if_team_does_not_exist();
//    $data['shift_list'] = $this->getAvialableShift();
//    $data['shift_list'][][] = shiftNameBySupervisor($userId);
//
////$shift = shiftNameBySupervisor($userId);
////pre($data['shift_list']);
//
    $data['team_submitted'] = 1;
//
//    $data['all_departments'] = $this->db->select(array('dept_id', 'dept_name'))->from('tbl_departments')->get()->result();
//
//
////$data['team_shift'] = $this->db->select('shift')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift;
//// $data['team_shift'] = shiftNameBySubDeptId($this->session->userdata('sub_department_id'));
//    $data['team_shift'] = $shift = shiftNameBySupervisor($userId);
//
////die;
//    $data['team_client'] = $this->db->select('client')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->client;
//
//
//    $data['shift_start_time'] = $this->db->select('shift_start_time')->from('tbl_manpower_team')->where('id', $data['team_id'])->get()->row()->shift_start_time;
//
//    $fetch_department_name_query = $this->db->query('SELECT dept_name FROM tbl_departments WHERE dept_id = ' . $deptArray['department_id']);
//
//    if ($fetch_department_name_query->num_rows()) {
//
//      $data['department_name'] = $fetch_department_name_query->row()->dept_name;
//    } else {
//
//      $data['department_name'] = '';
//    }
//
//    if (subDeptIdBySupervisor($userId)) {
//
//      $data['sub_department_name'] = subDeptName($deptArray['sub_department_id']) . ' : shift(' . shiftNameBySupervisor($userId) . ')';
//    } else {
//
//      $data['sub_department_name'] = '';
//    }

    $this->global['pageTitle'] = 'Searbird : Manpower Create Team';

    $data['client_list'] = $this->db->from('tbl_clients')->get()->result_array();

    $this->loadViews("manpower_create_team", $this->global, $data, NULL);
  }

  function create_team_post() {

    $team_already_exists = $this->db->select('id')->from('tbl_manpower_team')->where('department_id', $this->session->userdata('department_id'))->where('shift', $this->input->post('shift'))->where('date', date('Y-m-d'))->get()->num_rows();

    if ($team_already_exists) {

      $this->session->set_flashdata('message', '<div class = "alert alert-danger">Team already created for this department and shift!</div>');
    } else {

      $insert_data = array(
        'department_id' => $this->session->userdata('department_id'),
        'shift' => $this->input->post('shift'),
        'date' => date('Y-m-d'),
        'created_by' => $this->session->userdata('userId')
      );

      $this->db->insert('tbl_manpower_team', $insert_data);
      $team_id = $this->db->insert_id();

      $insert_data = array(
        'manpower_team_id' => $team_id,
        'employee_id' => $this->session->userdata('userId')
      );

      $this->db->insert('tbl_manpower_team_members', $insert_data);

      foreach ($this->input->post('selected_employees') as $employee_id) {

        $insert_data = array(
          'manpower_team_id' => $team_id,
          'employee_id' => $employee_id
        );

        $this->db->insert('tbl_manpower_team_members', $insert_data);
      }

      $this->session->set_flashdata('message', '<div class = "alert alert-success">Team has been created successfully!</div>');
    }
    redirect('create-team');
  }

  function clients($clientId = '') {
    if ($this->role != '1' && $this->role != '8') {
      $this->loadThis();
    } else {
      $clientInfo = array();
      $original_value = '';
      $original_client_code = '';
      $this->db->order_by('client', 'desc');
      if ($clientId) {
        $this->db->select('tbl_clients.*');
        $this->db->where('id', $clientId);
        $clientInfo = $this->db->get('tbl_clients')->row_array();
        $original_value = isset($clientInfo['client']) ? $clientInfo['client'] : '';
        $original_client_code = isset($clientInfo['client_code']) ? $clientInfo['client_code'] : '';
      }
      if ($this->input->post()) {
        if (($this->input->post('client') != $original_value) || $clientId == '') {
          $is_unique = '|is_unique[tbl_clients.client]';
        } else {
          $is_unique = '';
        }
        if (($this->input->post('client_code') != $original_client_code) || $clientId == '') {
          $is_unique_code = '|is_unique[tbl_clients.client_code]';
        } else {
          $is_unique_code = '';
        }
        $this->form_validation->set_rules('client', 'Client', 'required|trim' . $is_unique);
        $this->form_validation->set_rules('client_code', 'Client Code', 'required|trim' . $is_unique_code);
        if ($this->form_validation->run() === TRUE) {
          $client = $this->input->post('client');
          $client_code = $this->input->post('client_code');
          if ($clientId) {
            $this->db->where('id', $clientId);
            $this->db->update('tbl_clients', ['client' => $client, 'client_code' => $client_code]);
            $this->session->set_flashdata('success', 'Client updated successfully');
          } else {
            $this->db->insert('tbl_clients', ['client' => $client, 'client_code' => $client_code]);
            $this->session->set_flashdata('success', 'New Client created successfully');
          }
          redirect(site_url('clients'));
        }
      }
      $this->global['pageTitle'] = 'Searbird : Clients';
      $data['clientList'] = $this->db->get('tbl_clients')->result_array();
      $data['clientInfo'] = $clientInfo;
      $this->db->reset_query();
      $this->loadViews("clients_view", $this->global, $data, NULL);
    }
  }

  function delClient($clientId) {
    $this->db->where('id', $clientId);
    $this->db->delete('tbl_clients');
    $this->session->set_flashdata('success', 'Client deleted successfully');
    redirect(site_url('clients'));
  }

  function convertToHoursMins($time, $format = '%02d:%02d') {
    if ($time < 1) {
      return;
    }
    $hours = floor($time / 60);
    $minutes = ($time % 60);
    return sprintf($format, $hours, $minutes);
  }

  function getTotalHours() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $fromTime = $this->input->post('fromTime');
    $toTime = $this->input->post('toTime');
    $time1 = strtotime($fromTime);
    $time2 = strtotime($toTime);
    $difference = round(abs($time2 - $time1) / 60, 2);
    $diff = $this->convertToHoursMins($difference);
    echo json_encode($diff);
  }

  function getClientAjaxList() {
    if (!$this->input->is_ajax_request()) {
      exit('No direct script access allowed');
    }
    $userId = $this->session->userdata('userId');
    $draw = intval($this->input->post("draw"));
    $start = intval($this->input->post("start"));
    $length = intval($this->input->post("length"));
    $search = $this->input->post('search[value]');
    $this->db->select('tbl_clients.*');
    if (!empty($search)) {
      $likeCriteria = "(tbl_clients.client  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
    $query = $this->db->get('tbl_clients');
    $totalrows = $query->num_rows();

    $this->db->select('tbl_clients.*');
    if (!empty($search)) {
      $likeCriteria = "(tbl_clients.client  LIKE '%" . $search . "%')";
      $this->db->where($likeCriteria);
    }
    $this->db->order_by('tbl_clients.id', 'desc');
    $this->db->limit($length, $start);
    $results = $this->db->get('tbl_clients')->result_array();
//    $totalrows = count($results);
    $data = array();
    $sr = $start + 1;
    if (!empty($results)) {
      foreach ($results as $key => $client) {
        $attr = array();
        $attr[] = $sr;
        $attr[] = $client['client'];
        $attr[] = $client['client_code'];
        $attr[] = '<a href = "' . site_url('clients/' . $client['id']) . '" class = "btn btn-sm btn-primary"><i class = "fa fa-pencil-square-o" aria-hidden = "true"></i></a><a onclick = "return confirm(\'Are you sure\')" href = "' . site_url('delclient/' . $client['id']) . '" style = "margin-left:5px" class = "btn btn-sm btn-danger"><i class = "fa fa-trash" aria-hidden = "true"></i></a>';
        $data[] = $attr;
        $sr++;
      }
    }

    $output = array(
      "draw" => $draw,
      "recordsTotal" => $totalrows,
      "recordsFiltered" => $totalrows,
      "data" => $data
    );
    echo json_encode($output);
    exit();
  }

}
