<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

require APPPATH . '/libraries/BaseController.php';

/**
 * Class : Report (ReportController)
 * Visitor Class to control all user related operations.
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 30 August 2019
 */
class ReportFTUController extends BaseController {

  /**
   * This is default constructor of the class
   */
  public function __construct() {
    parent::__construct();
    $this->load->model('user_model');
    $this->isLoggedIn();
    date_default_timezone_set('Asia/Kolkata');
  }

  function view_report_new_detailed_c_l_w_d() {

    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == '11') {
      $locationList = $this->db->get('tbl_location')->result_array();
    } elseif ($this->role == '12') {
      $locationList = $this->db->select('*')->where_in('loc_id', $this->session->userdata('location_id'))->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')
              //->where('client_id', $clientId)
              ->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';

    if ($this->role == 10) {
      // $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
      $this->db->where_in('location_id', explode(',', $this->session->userdata('location_id')));
      $clientList = $this->db->get('tbl_clients')->result_array();
    } else {
      $clientList = $this->db->where('location_id', $locationId)->get('tbl_clients')->result_array();
    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';

    if ($this->role == '11') {
      $warehouseList = $this->db->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '5'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('client_id', $clientId)->get('tbl_organization')->result_array();
    }
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;
    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_detailed_c_l_w_d", $this->global, $data, NULL);
  }

  function view_report_new_ftu_c_l_w_d_sd() {


    $orgId = '';
    if ($this->role == 2 || $this->role == 8) {
      $orgId = $this->organization_id;
    }
    if ($this->role == '11') {
      $locationList = $this->db->get('tbl_location')
//              ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
          ->where('tbl_location.isDeleted', '0')
          ->group_by('tbl_location.loc_id')
          ->result_array();
    } elseif ($this->role == '12') {
      $locationList = $this->db->select('*')
//                      ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
//                      ->where_in('loc_id', $this->session->userdata('location_id'))
              ->get('tbl_location')->result_array();
    } else {
      $locationList = $this->db->select('*')
//                      ->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.location = tbl_location.loc_id', 'right')
              ->where('tbl_location.isDeleted', '0')
              ->group_by('tbl_location.loc_id')
              ->get('tbl_location')->result_array();
    }
    $locationId = isset($locationList[0]['loc_id']) ? $locationList[0]['loc_id'] : '';
    if ($this->role == '11') {
      $warehouseList = $this->db->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } elseif (in_array($this->role, ['2', '8', '9', '4'])) {
      $warehouseList = $this->db->where('id', $this->session->userdata('organization_id'))->where('isDeleted', '0')->get('tbl_organization')->result_array();
    } else {
      $warehouseList = $this->db->where('isDeleted', '0')->get('tbl_organization')->result_array();
//      $warehouseList = $this->db->where('loc_id', $locationId)->where('isDeleted', '0')->get('tbl_organization')->result_array();
    }
    //last_query();
    //pre($warehouseList);
    $warehouseId = isset($warehouseList[0]['id']) ? $warehouseList[0]['id'] : '';
//    if ($this->role == 10) {
//      // $lientIdsArray = clientIdByLocationId(explode(',', $this->session->userdata('location_id')));
//      $this->db->where_in('location_id', explode(',', $this->session->userdata('location_id')));
    if (isset($warehouseList[0]['client_id'])) {
      $this->db->where_in('id', explode(',', $warehouseList[0]['client_id']));
    }
    $clientList = $this->db->get('tbl_clients')->result_array();
    //pre($clientList);
    //last_query();
//    } else {
//      $clientList = $this->db->where('location_id', $locationId)->get('tbl_clients')->result_array();
//    }
    $clientId = isset($clientList[0]['id']) ? $clientList[0]['id'] : '';
    //die;




    $departmentList = $this->user_model->getDepartmentListAll($warehouseId, '', '', '0');
    $data['clientList'] = $clientList;
    $data['locationList'] = $locationList;
    $data['warehouseList'] = $warehouseList;
    $data['departmentList'] = $departmentList;
    $data['role'] = $this->role;
    $data['department_id'] = $this->department_id;
    $this->global['pageTitle'] = 'Searbird : View Report';
    $this->loadViews("manpower_view_report_new_ftu_c_l_w_d_sd", $this->global, $data, NULL);
  }

  function get_date_ranged_report_excel_new_ftu() {
    //pre($this->input->post());
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $shift = $this->input->post('shift');
      $subdepartment = $this->input->post('subdepartment');
      $departmentId = $this->input->post('departmentId');
      $clientId = $this->input->post('clientId');
      $organizationid = $this->input->post('warehouseId');
      $locationId = $this->input->post('locationId');
//      if ($shift != '') {
      $this->get_date_ranged_report_excel_new_ftu_l_w_c_d_sd_shift();
      die;
//      } elseif ($subdepartment != '') {
//        $this->get_date_ranged_report_excel_new_ftu_l_w_c_d_sd();
//        die;
//      } elseif ($departmentId != '') {
//        $this->get_date_ranged_report_excel_new_detailed_l_w_c_d();
//        die;
//      } elseif ($clientId != '') {
//        $this->get_date_ranged_report_excel_new_ftu_l_w_c();
//        die;
//      } elseif ($organizationid != '') {
//        $this->get_date_ranged_report_excel_new_ftu_l_w();
//        die;
//      } elseif ($locationId != '') {
//        $this->get_date_ranged_report_excel_new_ftu_l();
//        die;
//      }
      //pre($this->input->post());
      // $this->get_date_ranged_report_excel_new_ftu_c_l_w_d();
      die;
    }
  }

  function get_date_ranged_report_excel_new_ftu_l() {
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'ftu_productivity_report.xls';
    $where = ' ';
    $select = ' ';
    $groupBY = '  GROUP BY location';
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
      $groupBY = ' GROUP BY location';
    } elseif ($location_id == 'all') {
      $groupBY = ' GROUP BY location';
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
      $groupBY = ' GROUP BY client';
    } elseif ($client_id == 'all') {
      $groupBY = ' GROUP BY client';
    }

    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
      $groupBY = ' GROUP BY org';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org';
    }
    if ($department_id != '' && $department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
      $groupBY = ' GROUP BY dept_id';
    } elseif ($department_id == 'all') {
      $groupBY = ' GROUP BY dept_id';
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
      $groupBY = ' GROUP BY sub_dept_id';
    } elseif ($sub_department_id == 'all') {
      $groupBY = ' GROUP BY sub_dept_id';
    }
    $groupBY = ' GROUP BY date';
    $all_team_ids = $this->db->query('SELECT * FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName($location_id))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Report Type')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', ($location_id) ? "free employee of " . locationName($location_id) : "Free Employee Report")->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Date Range')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', $fromDate . '-to-' . $toDate)->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Report Generated Date & Time')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', date("Y-m-d H:i:s"))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Employee Name')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B5', 'Emp Code')->getStyle('B7')->getFont()->setBold(true);
    $char = "C";
    $nod = count($all_team_ids);
    foreach ($all_team_ids as $key => $date) {
      $this->excel->getActiveSheet()->setCellValue($char . '5', $date['date'])->getStyle($char . '5')->getFont()->setBold(true);
      $char++;
    }
    $pro = $char++;
    $ach = $char++;
    $this->excel->getActiveSheet()->setCellValue($pro . '5', 'Total Free Hours')->getStyle($pro . '5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue($ach . '5', 'Average')->getStyle($ach . '5')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 6;
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $char = "C";
          $dataaa = $this->getWorkingLogData($date['superviser_id'], $date['dept_id'], $date['sub_dept_id'], $date['employee_id'], $date['shift'], $fromDate, $toDate);
          $totall = 0;
          foreach ($dataaa as $key => $dataa) {
            $this->excel->getActiveSheet()->setCellValue($char . $excelrow, $dataa['total_hours'])->getStyle($char . $excelrow)->getFont()->setBold(true);
            $temp = explode(":", $dataa['total_hours']);
            $totall += (int) $temp[0] * 3600;
            $totall += (int) $temp[1] * 60;
            $totall += (int) $temp[2];
            $char++;
          }
          $pro = $char++;
          $ach = $char++;
          $this->excel->getActiveSheet()->setCellValue($pro . $excelrow, gmdate('H:i:s', $totall))->getStyle($pro . $excelrow)->getFont()->setBold(true);
          $this->excel->getActiveSheet()->setCellValue($ach . $excelrow, gmdate('H:i:s', ($totall / $nod)))->getStyle($ach . $excelrow)->getFont()->setBold(true);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

//      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
//      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
//      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
//      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
//      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
//      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, ($total / 3600) . ':' . ($total / 60 % 60) . ':' . $total % 60);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_ftu_l_w() {
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'ftu_productivity_report.xls';
    $where = ' ';
    $select = ' ';
    $groupBY = '  GROUP BY location';
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
      $groupBY = ' GROUP BY location';
    } elseif ($location_id == 'all') {
      $groupBY = ' GROUP BY location';
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
      $groupBY = ' GROUP BY client';
    } elseif ($client_id == 'all') {
      $groupBY = ' GROUP BY client';
    }

    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
      $groupBY = ' GROUP BY org';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org';
    }
    if ($department_id != '' && $department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
      $groupBY = ' GROUP BY dept_id';
    } elseif ($department_id == 'all') {
      $groupBY = ' GROUP BY dept_id';
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
      $groupBY = ' GROUP BY sub_dept_id';
    } elseif ($sub_department_id == 'all') {
      $groupBY = ' GROUP BY sub_dept_id';
    }
    $groupBY = ' GROUP BY date';
    $all_team_ids = $this->db->query('SELECT * FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Report Type')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', ($organization_id) ? "free employee of " . orgName($organization_id) : "Free Employee Report")->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Date Range')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', $fromDate . '-to-' . $toDate)->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Report Generated Date & Time')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', date("Y-m-d H:i:s"))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Employee Name')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B5', 'Emp Code')->getStyle('B7')->getFont()->setBold(true);
    $char = "C";
    $nod = count($all_team_ids);
    foreach ($all_team_ids as $key => $date) {
      $this->excel->getActiveSheet()->setCellValue($char . '5', $date['date'])->getStyle($char . '5')->getFont()->setBold(true);
      $char++;
    }
    $pro = $char++;
    $ach = $char++;
    $this->excel->getActiveSheet()->setCellValue($pro . '5', 'Total Free Hours')->getStyle($pro . '5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue($ach . '5', 'Average')->getStyle($ach . '5')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 6;
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $char = "C";
          $dataaa = $this->getWorkingLogData($date['superviser_id'], $date['dept_id'], $date['sub_dept_id'], $date['employee_id'], $date['shift'], $fromDate, $toDate);
          $totall = 0;
          foreach ($dataaa as $key => $dataa) {
            $this->excel->getActiveSheet()->setCellValue($char . $excelrow, $dataa['total_hours'])->getStyle($char . $excelrow)->getFont()->setBold(true);
            $temp = explode(":", $dataa['total_hours']);
            $totall += (int) $temp[0] * 3600;
            $totall += (int) $temp[1] * 60;
            $totall += (int) $temp[2];
            $char++;
          }
          $pro = $char++;
          $ach = $char++;
          $this->excel->getActiveSheet()->setCellValue($pro . $excelrow, gmdate('H:i:s', $totall))->getStyle($pro . $excelrow)->getFont()->setBold(true);
          $this->excel->getActiveSheet()->setCellValue($ach . $excelrow, gmdate('H:i:s', ($totall / $nod)))->getStyle($ach . $excelrow)->getFont()->setBold(true);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

//      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
//      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
//      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
//      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
//      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
//      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, ($total / 3600) . ':' . ($total / 60 % 60) . ':' . $total % 60);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_ftu_l_w_c() {
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'ftu_productivity_report.xls';
    $where = ' ';
    $select = ' ';
    $groupBY = '  GROUP BY location';
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
      $groupBY = ' GROUP BY location';
    } elseif ($location_id == 'all') {
      $groupBY = ' GROUP BY location';
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
      $groupBY = ' GROUP BY client';
    } elseif ($client_id == 'all') {
      $groupBY = ' GROUP BY client';
    }

    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
      $groupBY = ' GROUP BY org';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org';
    }
    if ($department_id != '' && $department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
      $groupBY = ' GROUP BY dept_id';
    } elseif ($department_id == 'all') {
      $groupBY = ' GROUP BY dept_id';
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
      $groupBY = ' GROUP BY sub_dept_id';
    } elseif ($sub_department_id == 'all') {
      $groupBY = ' GROUP BY sub_dept_id';
    }
    $groupBY = ' GROUP BY date';
    $all_team_ids = $this->db->query('SELECT * FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Report Type')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', ($client_id) ? "free employee of " . clientName($client_id) : "Free Employee Report")->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Date Range')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', $fromDate . '-to-' . $toDate)->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Report Generated Date & Time')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', date("Y-m-d H:i:s"))->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Employee Name')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B7', 'Emp Code')->getStyle('B7')->getFont()->setBold(true);
    $char = "C";
    $nod = count($all_team_ids);

    foreach ($all_team_ids as $key => $date) {
      $this->excel->getActiveSheet()->setCellValue($char . '7', $date['date'])->getStyle($char . '7')->getFont()->setBold(true);
      $char++;
    }
    $pro = $char++;
    $ach = $char++;
    $this->excel->getActiveSheet()->setCellValue($pro . '7', 'Total Free Hours')->getStyle($pro . '7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue($ach . '7', 'Average')->getStyle($ach . '7')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 8;
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $char = "C";
          $dataaa = $this->getWorkingLogData($date['superviser_id'], $date['dept_id'], $date['sub_dept_id'], $date['employee_id'], $date['shift'], $fromDate, $toDate);
          $totall = 0;
          foreach ($dataaa as $key => $dataa) {
            $this->excel->getActiveSheet()->setCellValue($char . $excelrow, $dataa['total_hours'])->getStyle($char . $excelrow)->getFont()->setBold(true);
            $temp = explode(":", $dataa['total_hours']);
            $totall += (int) $temp[0] * 3600;
            $totall += (int) $temp[1] * 60;
            $totall += (int) $temp[2];
            $char++;
          }
          $pro = $char++;
          $ach = $char++;
          $this->excel->getActiveSheet()->setCellValue($pro . $excelrow, gmdate('H:i:s', $totall))->getStyle($pro . $excelrow)->getFont()->setBold(true);
          $this->excel->getActiveSheet()->setCellValue($ach . $excelrow, gmdate('H:i:s', ($totall / $nod)))->getStyle($ach . $excelrow)->getFont()->setBold(true);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

//      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
//      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
//      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
//      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
//      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
//      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, ($total / 3600) . ':' . ($total / 60 % 60) . ':' . $total % 60);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_detailed_l_w_c_d() {
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'ftu_productivity_report.xls';
    $where = ' ';
    $select = ' ';
    $groupBY = '  GROUP BY location';
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
      $groupBY = ' GROUP BY location';
    } elseif ($location_id == 'all') {
      $groupBY = ' GROUP BY location';
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
      $groupBY = ' GROUP BY client';
    } elseif ($client_id == 'all') {
      $groupBY = ' GROUP BY client';
    }

    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
      $groupBY = ' GROUP BY org';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org';
    }
    if ($department_id != '' && $department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
      $groupBY = ' GROUP BY dept_id';
    } elseif ($department_id == 'all') {
      $groupBY = ' GROUP BY dept_id';
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
      $groupBY = ' GROUP BY sub_dept_id';
    } elseif ($sub_department_id == 'all') {
      $groupBY = ' GROUP BY sub_dept_id';
    }
    $groupBY = ' GROUP BY date';
    $all_team_ids = $this->db->query('SELECT * FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Report Type')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', ($department_id) ? "free employee of " . deptName($department_id) : "Free Employee Report")->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Date Range')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', $fromDate . '-to-' . $toDate)->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Report Generated Date & Time')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B7:O7')->setCellValue('B7', date("Y-m-d H:i:s"))->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A8', 'Employee Name')->getStyle('A8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B8', 'Emp Code')->getStyle('B8')->getFont()->setBold(true);
    $char = "C";
    $nod = count($all_team_ids);
    foreach ($all_team_ids as $key => $date) {
      $this->excel->getActiveSheet()->setCellValue($char . '8', $date['date'])->getStyle($char . '8')->getFont()->setBold(true);
      $char++;
    }
    $pro = $char++;
    $ach = $char++;
    $this->excel->getActiveSheet()->setCellValue($pro . '8', 'Total Free Hours')->getStyle($pro . '8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue($ach . '8', 'Average')->getStyle($ach . '8')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 9;
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $char = "C";
          $dataaa = $this->getWorkingLogData($date['superviser_id'], $date['dept_id'], $date['sub_dept_id'], $date['employee_id'], $date['shift'], $fromDate, $toDate);
          $totall = 0;
          foreach ($dataaa as $key => $dataa) {
            $this->excel->getActiveSheet()->setCellValue($char . $excelrow, $dataa['total_hours'])->getStyle($char . $excelrow)->getFont()->setBold(true);
            $temp = explode(":", $dataa['total_hours']);
            $totall += (int) $temp[0] * 3600;
            $totall += (int) $temp[1] * 60;
            $totall += (int) $temp[2];
            $char++;
          }
          $pro = $char++;
          $ach = $char++;
          $this->excel->getActiveSheet()->setCellValue($pro . $excelrow, gmdate('H:i:s', $totall))->getStyle($pro . $excelrow)->getFont()->setBold(true);
          $this->excel->getActiveSheet()->setCellValue($ach . $excelrow, gmdate('H:i:s', ($totall / $nod)))->getStyle($ach . $excelrow)->getFont()->setBold(true);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

//      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
//      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
//      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
//      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
//      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
//      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, ($total / 3600) . ':' . ($total / 60 % 60) . ':' . $total % 60);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_ftu_l_w_c_d_sd() {
    $total = 0;
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'ftu_productivity_report.xls';
    $where = ' ';
    $select = ' ';
    $groupBY = '  GROUP BY location';
    if ($location_id != '' && $location_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.location = ' . $location_id;
      $groupBY = ' GROUP BY location';
    } elseif ($location_id == 'all') {
      $groupBY = ' GROUP BY location';
    }
    if ($client_id != '' && $client_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.client = ' . $client_id;
      $groupBY = ' GROUP BY client';
    } elseif ($client_id == 'all') {
      $groupBY = ' GROUP BY client';
    }

    if ($organization_id != '' && $organization_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.org = ' . $organization_id;
      $groupBY = ' GROUP BY org';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org';
    }
    if ($department_id != '' && $department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.dept_id = ' . $department_id;
      $groupBY = ' GROUP BY dept_id';
    } elseif ($department_id == 'all') {
      $groupBY = ' GROUP BY dept_id';
    }
    if ($sub_department_id != '' && $sub_department_id != 'all') {
      $where .= ' AND tbl_manpower_team_performance.sub_dept_id = ' . $sub_department_id;
      $groupBY = ' GROUP BY sub_dept_id';
    } elseif ($sub_department_id == 'all') {
      $groupBY = ' GROUP BY sub_dept_id';
    }
    $groupBY = ' GROUP BY date';
    $all_team_ids = $this->db->query('SELECT * FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', locationName(locationIdByOrgId($organization_id)))->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', orgName($organization_id))->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Client Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B3:O3')->setCellValue('B3', clientName($client_id))->getStyle('B3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A4', 'Department')->getStyle('A4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B4:O4')->setCellValue('B4', deptName($department_id))->getStyle('B4')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A5', 'Sub Department')->getStyle('A5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B5:O5')->setCellValue('B5', subDeptName($sub_department_id))->getStyle('B5')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A6', 'Report Type')->getStyle('A6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B6:O6')->setCellValue('B6', ($sub_department_id) ? "free employee of " . subDeptName($sub_department_id) : "Free Employee Report")->getStyle('B6')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A7', 'Date Range')->getStyle('A7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B7:O7')->setCellValue('B7', $fromDate . '-to-' . $toDate)->getStyle('B7')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A8', 'Report Generated Date & Time')->getStyle('A8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B8:O8')->setCellValue('B8', date("Y-m-d H:i:s"))->getStyle('B8')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A9', 'Employee Name')->getStyle('A9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B9', 'Emp Code')->getStyle('B9')->getFont()->setBold(true);
    $char = "C";
    $nod = count($all_team_ids);
    foreach ($all_team_ids as $key => $date) {
      $this->excel->getActiveSheet()->setCellValue($char . '9', $date['date'])->getStyle($char . '9')->getFont()->setBold(true);
      $char++;
    }
    $pro = $char++;
    $ach = $char++;
    $this->excel->getActiveSheet()->setCellValue($pro . '9', 'Total Free Hours')->getStyle($pro . '9')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue($ach . '9', 'Average')->getStyle($ach . '9')->getFont()->setBold(true);
    $fChallan = 0;
    $fBoxes = 0;
    $fQty = 0;
    $fSku = 0;
    $fEmp = 0;
    if (!empty($all_team_ids)) {
      $excelrow = 10;
      $groupBY = ' GROUP BY employee_id';

      $total_challans = $this->db->query('SELECT *, IFNULL(SUM(challans), 0) AS total_challans,date ' . $select . ' FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $totalcount = count($total_challans);
      if ($totalcount == '0') {
        $this->session->set_flashdata('success', 'Data Not Found with your Search.');
        redirect('view-report-new-detailed-c-l-w-d-sd');
      }
      $total_boxes = $this->db->query('SELECT IFNULL(SUM(A), 0) AS total_boxes,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_qty = $this->db->query('SELECT IFNULL(SUM(B), 0) AS total_qty,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_sku = $this->db->query('SELECT IFNULL(SUM(C), 0) AS total_sku,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_manpower = $this->db->query('SELECT IFNULL(COUNT(absent),0) AS manpower,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $client_list = $this->db->query('SELECT GROUP_CONCAT(DISTINCT CONCAT(\'"\', `client`, \'"\')) AS `clientlist`, date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      $total_time = $this->db->query('SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(time))),0) AS total_time,date ' . $select . '  FROM tbl_manpower_team_performance WHERE date >=\'' . $this->input->post('from_date') . '\' AND date <= \'' . $this->input->post('to_date') . '\' ' . $where . $groupBY)->result_array();
      if (!empty($total_challans)) {
        foreach ($total_challans as $key1 => $challan) {
          $fChallan += $TCHALLAN = $challan['total_challans'];
          $fBoxes += $TOTALBOXES = isset($total_boxes[$key1]['total_boxes']) ? $total_boxes[$key1]['total_boxes'] : 0;
          $fQty += $TOTALQTY = isset($total_qty[$key1]['total_qty']) ? $total_qty[$key1]['total_qty'] : 0;
          $fSku += $TOTALSKU = isset($total_sku[$key1]['total_sku']) ? $total_sku[$key1]['total_sku'] : 0;
          $fEmp += $TOTALMANPOWER = isset($total_manpower[$key1]['manpower']) ? $total_manpower[$key1]['manpower'] : 0;
          $TOTALTIME = isset($challan['time']) ? strtotime($challan['time']) : strtotime('00:00:00');
          $fTime += $TOTALTIME;
          $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, ucfirst(empNameById($challan['employee_id'])));
          $this->excel->getActiveSheet()->setCellValue('B' . $excelrow, ucfirst(empCodeByEmpId($challan['employee_id'])));
          $char = "C";
          $dataaa = $this->getWorkingLogData($date['superviser_id'], $date['dept_id'], $date['sub_dept_id'], $date['employee_id'], $date['shift'], $fromDate, $toDate);
          $totall = 0;
          foreach ($dataaa as $key => $dataa) {
            $this->excel->getActiveSheet()->setCellValue($char . $excelrow, $dataa['total_hours'])->getStyle($char . $excelrow)->getFont()->setBold(true);
            $temp = explode(":", $dataa['total_hours']);
            $totall += (int) $temp[0] * 3600;
            $totall += (int) $temp[1] * 60;
            $totall += (int) $temp[2];
            $char++;
          }
          $pro = $char++;
          $ach = $char++;
          $this->excel->getActiveSheet()->setCellValue($pro . $excelrow, gmdate('H:i:s', $totall))->getStyle($pro . $excelrow)->getFont()->setBold(true);
          $this->excel->getActiveSheet()->setCellValue($ach . $excelrow, gmdate('H:i:s', ($totall / $nod)))->getStyle($ach . $excelrow)->getFont()->setBold(true);
          fputcsv($output, [$team_details->shift, '', $team_details->department_name, $challan['date'], $team_details->created_by, $challan['total_challans'], $total_boxes[$key]['total_boxes'], $total_qty[$key]['total_qty'], $total_sku[$key]['total_sku'], $total_manpower[$key]['manpower']]);

          $element = $challan['time'];
          // Explode by seperator :
          $temp = explode(":", $element);

          // Convert the hours into seconds
          // and add to total
          $total += (int) $temp[0] * 3600;

          // Convert the minutes to seconds
          // and add to total
          $total += (int) $temp[1] * 60;

          // Add the seconds to total
          $total += (int) $temp[2];

          $excelrow++;
        }
      }

//      $this->excel->getActiveSheet()->setCellValue('A' . $excelrow, 'Total : ')->getStyle('B' . $excelrow)->getFont()->setBold(true);
//      $this->excel->getActiveSheet()->setCellValue('E' . $excelrow, $fChallan);
//      $this->excel->getActiveSheet()->setCellValue('F' . $excelrow, $fBoxes);
//      $this->excel->getActiveSheet()->setCellValue('G' . $excelrow, $fQty);
//      $this->excel->getActiveSheet()->setCellValue('H' . $excelrow, $fSku);
//      $this->excel->getActiveSheet()->setCellValue('M' . $excelrow, ($total / 3600) . ':' . ($total / 60 % 60) . ':' . $total % 60);
    }
    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function get_date_ranged_report_excel_new_ftu_l_w_c_d_sd_shift() {
    $total = 0;
//    pre(utfDepartmentByOrg());
//    pre($this->input->post());
    $this->load->library('excel');
    $this->load->helper('report');
    if ($this->session->userdata('role') == '4') {
      $department_id = $this->session->userdata('department_id');
      $sub_department_id = $this->session->userdata('sub_department_id');
    } else {
      $location_id = $this->input->post('locationId');
      $organization_id = $this->input->post('warehouseId');
      $client_id = $this->input->post('clientId');
      $department_id = $this->input->post('departmentId');
      $sub_department_id = $this->input->post('subdepartment');
      $shift_id = $this->input->post('shift');
    }
    $fromDate = $this->input->post('from_date');
    $toDate = $this->input->post('to_date');
    $date = $this->input->post('date');
    $filename = 'ftu_productivity_report.xls';
    $where = 'status = "4" AND  check_in >=\'' . $this->input->post('from_date') . ' 00:00:01' . '\' AND check_in <= \'' . $this->input->post('to_date') . ' 23:59:01' . '\' ';
    $select = ' ';

    if ($organization_id != '' && $organization_id != 'all') {
      $where .= '  AND working_logs.org_id = ' . $organization_id;
      $groupBY = ' GROUP BY org_id';
    } elseif ($organization_id == 'all') {
      $groupBY = ' GROUP BY org_id';
    }

    $groupBY = ' GROUP BY user_id';
    $all_team_ids = $this->db->query('SELECT *,user_id as userId FROM working_logs  WHERE  ' . $where . $groupBY)->result_array();
//    last_query();
//    pre($all_team_ids);
    $totalcount = count($all_team_ids);
    $this->excel->setActiveSheetIndex(0);
    $this->excel->getActiveSheet()->setTitle('Report');
    $this->excel->getActiveSheet()->setCellValue('A1', 'Location')->getStyle('A1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B1:O1')->setCellValue('B1', (!empty($location_id) && is_numeric($location_id) && $location_id != 'all') ? locationName($location_id) : 'All')->getStyle('B1')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A2', 'Warehouse')->getStyle('A2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->mergeCells('B2:O2')->setCellValue('B2', (!empty($organization_id) && is_numeric($organization_id) && $organization_id != 'all') ? orgName($organization_id) : 'All')->getStyle('B2')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('A3', 'Employee Name')->getStyle('A3')->getFont()->setBold(true);
    $this->excel->getActiveSheet()->setCellValue('B3', 'Employee Code')->getStyle('B3')->getFont()->setBold(true);

    $char = "C";

    $daterange = getDatesFromRange($this->input->post('from_date'), $this->input->post('to_date'), $format = 'Y-m-d');
//    $nod = count($all_team_ids);
    foreach ($daterange as $key => $date) {
      $this->excel->getActiveSheet()->setCellValue($char . '3', $date)->getStyle($char . '3')->getFont()->setBold(true);
      $char++;
    }
    $pro = $char++;
    $ach = $char++;
//    $this->excel->getActiveSheet()->setCellValue($pro . '3', 'Total Free Hours')->getStyle($pro . '3')->getFont()->setBold(true);
//    $this->excel->getActiveSheet()->setCellValue($ach . '3', 'Average')->getStyle($ach . '3')->getFont()->setBold(true);
    $row = '4';
    foreach ($all_team_ids as $emp) {
      $this->excel->getActiveSheet()->setCellValue('A' . $row, empNameById($emp['userId']))->getStyle('A' . $row)->getFont()->setBold(true);
      $this->excel->getActiveSheet()->setCellValue('B' . $row, empCodeByEmpId($emp['userId']))->getStyle('B' . $row)->getFont()->setBold(true);
      $char = "C";
      foreach ($daterange as $key => $date) {
        $where = ' AND user_id = ' . $emp['userId'] . ' AND status = "4"';
        if ($location_id != '' && $location_id != 'all') {
          $where .= '  ';
          $groupBY = ' ';
        } elseif ($location_id == 'all') {
          $groupBY = ' ';
        }
        if ($organization_id != '' && $organization_id != 'all') {
          $where .= ' AND working_logs.org_id = ' . $organization_id . ' ';
          $groupBY = ' GROUP BY org_id';
        } elseif ($organization_id == 'all') {
          $groupBY = ' GROUP BY org_id';
        }

        $groupBY = ' GROUP BY user_id';
        $wl = [];
        $wl = $this->db->query('SELECT SEC_TO_TIME((sum(TIME_TO_SEC(check_out)) - sum(TIME_TO_SEC(check_in)))) AS `total_hours` FROM working_logs  WHERE check_in like "' . $date . '%"' . $where . $groupBY)->row_array();
//        last_query();
//        pre($wl);
//        $daterange = getDatesFromRange($this->input->post('from_date'), $this->input->post('to_date'), $format = 'Y-m-d');
//    $nod = count($all_team_ids);
//        foreach ($daterange as $key => $date) {
        $this->excel->getActiveSheet()->setCellValue($char . $row, $wl['total_hours'] ? date("H:i:s", strtotime($wl['total_hours'])) : '---')->getStyle($char . $row)->getFont()->setBold(true);

        $char++;
//        }
      }$row++;

//      pre($emp);
    }

    header('Content-Type: application/vnd.ms-excel'); //mime type
    header('Content-Disposition: attachment;filename="' . $filename . '"'); //tell browser what's the file name
    header('Cache-Control: max-age=0'); //no cache
    $objWriter = PHPExcel_IOFactory::createWriter($this->excel, 'Excel5');
    $objWriter->save('php://output');
    exit;
  }

  function getWorkingLogData($supervisorId, $deptId, $subDept_id, $empId, $shiftId, $fromDate, $toDate) {
    //$date = $date . "%";
    $selectQuery = "SELECT * ,SEC_TO_TIME((TIME_TO_SEC(check_out) - TIME_TO_SEC(check_in))) AS `total_hours`"
        . " from working_logs"
        . " WHERE superviser_id = " . $supervisorId
        . " AND dept_id = " . $deptId
        . " AND sub_dept_id = " . $subDept_id
        . " AND user_id = " . $empId
        . " AND shift_id = '" . shiftIdByName($shiftId) . "'"
        . " AND check_out != ''"
        . " AND created_at >='" . $fromDate . " 00:00:01'"
        . " AND created_at < '" . $toDate . " 23:59:59'"
        . " group by created_at ";
    //die;
    //die;
    $query = $this->db->query($selectQuery);
    return $employees = $query->result_array();
  }

}
