<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

/**
 * This function is used to print the content of any data
 */
function pre($var, $exit = true) {
  echo "<pre>";
  print_r($var);
  echo "</pre>";
  if ($exit) {
    exit;
  }
}

/**
 * This function is used to print the content of any data
 */
function last_query() {
  echo get_instance()->db->last_query();
  die;
}

/**
 * This function used to get the CI instance
 */
if (!function_exists('get_instance')) {

  function get_instance() {
    $CI = &get_instance();
  }

}

/**
 * This function used to generate the hashed password
 * @param {string} $plainPassword : This is plain text password
 */
if (!function_exists('getHashedPassword')) {

  function getHashedPassword($plainPassword) {
    return password_hash($plainPassword, PASSWORD_DEFAULT);
  }

}

/**
 * This function used to generate the hashed password
 * @param {string} $plainPassword : This is plain text password
 * @param {string} $hashedPassword : This is hashed password
 */
if (!function_exists('verifyHashedPassword')) {

  function verifyHashedPassword($plainPassword, $hashedPassword) {
    return password_verify($plainPassword, $hashedPassword) ? true : false;
  }

}

/**
 * This method used to get current browser agent
 */
if (!function_exists('getBrowserAgent')) {

  function getBrowserAgent() {
    $CI = get_instance();
    $CI->load->library('user_agent');

    $agent = '';

    if ($CI->agent->is_browser()) {
      $agent = $CI->agent->browser() . ' ' . $CI->agent->version();
    } else if ($CI->agent->is_robot()) {
      $agent = $CI->agent->robot();
    } else if ($CI->agent->is_mobile()) {
      $agent = $CI->agent->mobile();
    } else {
      $agent = 'Unidentified User Agent';
    }

    return $agent;
  }

}

if (!function_exists('setProtocol')) {

  function setProtocol() {
    $CI = &get_instance();
    $CI->load->library('email');
    $config['protocol'] = 'smtp';
    $config['mailpath'] = '/usr/sbin/sendmail';
    $config['smtp_host'] = 'smtp.gmail.com';
    $config['smtp_port'] = '587';
    $config['smtp_user'] = 'eems@gmail.com';
    $config['smtp_pass'] = 'eems@123';
    $config['charset'] = "utf-8";
    $config['mailtype'] = "html";
    $config['newline'] = "\r\n";
    $CI->email->initialize($config);

    return $CI;
  }

}

if (!function_exists('emailConfig')) {

  function emailConfig() {
    $CI->load->library('email');
    $config['protocol'] = 'smtp';
    $config['smtp_host'] = 'smtp.gmail.com';
    $config['smtp_port'] = '587';
    $config['mailpath'] = '/usr/sbin/sendmail';
    $config['charset'] = 'UTF-8';
    $config['mailtype'] = "html";
    $config['newline'] = "\r\n";
    $config['wordwrap'] = TRUE;
  }

}

if (!function_exists('resetPasswordEmail')) {

  function resetPasswordEmail($detail) {
    $data = $detail;
//    $data["data"] = $detail;
//    $CI = setProtocol();
//    $CI->email->from('noreply@.com', $detail['name']);
//    $CI->email->subject("Reset Password");
//    $CI->email->message($CI->load->view('email/resetPassword', $data, TRUE));
//    $CI->email->to($detail["email"]);
//    $status = $CI->email->send();
//    return $status;



    $to = $detail["email"];
    $subject = "Reset Your Password";

    $message = '<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Reset Your Password</title>
  </head>
  <body>
    <div>
      <table style="width:100%;border-spacing:0" cellpadding="0" cellspacing="0">
        <tbody>
          <tr>
            <th style="border-top:solid 5px #f56400;font-weight:normal;text-align:center;background:#ffffff;border-bottom:solid 1px #e3e5e1">
              <table style="width:100%;max-width:596px;border-spacing:0;margin:0 auto" cellpadding="0" cellspacing="0" align="center">
                <tbody>
                  <tr>
                    <td>
                      <table style="margin:0%;width:100%;border-spacing:0;table-layout:fixed" cellpadding="0" cellspacing="0">
                        <tbody>
                          <tr>
                            <td style="padding:17px 3.358% 15px">
                              <cite style="text-align:center;display:block;font-style:normal">
                                <span style="font-size:1px;min-height:0;color:#fff;width:0;display:block">Just one more step.</span>
                                <dl style="list-style-type:none;padding:0;overflow:hidden;margin:0">
                                  <dt style="font-size:15px;display:inline-block;width:100%;margin:0;padding:0 0 12px 0;vertical-align:top;padding-bottom:0!important">
                                    <a href="<?php echo base_url(); ?>" title="CodeInsect" style="display:inline-block" target="_blank"></a>
                                  </dt>
                                  <div style="font-size:15px;display:inline-block;width:100%;margin:0;vertical-align:top"></div>
                                </dl>
                              </cite>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </td>
                  </tr>
                </tbody>
              </table>
            </th>
          </tr>
          <tr><th style="background:#f5f5f1;height:28px"></th></tr>
          <tr>
            <th style="background:#f5f5f1;font-weight:normal;text-align:left">
              <table style="width:100%;max-width:596px;border-spacing:0;margin:0 auto" cellpadding="0" cellspacing="0" align="center">
                <tbody>
                  <tr>
                    <td>
                      <table style="margin:0%;width:100%;border-spacing:0;table-layout:fixed" cellpadding="0" cellspacing="0">
                        <tbody>
                          <tr>
                            <td style="padding:0 3.358%;font-size:15px;color:#555;line-height:24px">
                              <div style="min-height:28px"></div>
                              <div style="padding:24px 3.6% 24px;background:#fff;border:1px solid #e3e5e1">
                                <table cellpadding="0" cellspacing="0" style="width:100%;margin:0;padding:0">
                                  <tbody>
                                    <tr>
                                      <td align="center">
                                        <div style="width:100%">
                                          <b>Hi, ' . $data["name"] . '</b>! <span class="il">' . $data["message"] . '</span>
                                          <div style="min-height:20px"></div>
                                          <div style="width:100%">
                                            <a style="display:inline-block;font-size:15px;padding:10px 18px;vertical-align:middle;color:#ffffff;background:#34a8c4;border-top:solid 1px #2c8ea6;border-right:solid 1px #2c8ea6;border-bottom:solid 1px #2c8ea6;border-left:solid 1px #2c8ea6;border-radius:3px;text-decoration:none;white-space:normal;font-weight:bold;line-height:18px" href="' . $data['reset_link'] . '" target="_blank"> <span class="il"> Reset Password Link </span></a>
                                          </div>
                                          <div style="min-height:28px"></div>
                                        </div>
                                      </td>
                                    </tr>
                                  </tbody>
                                </table>
                              </div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                    </td>
                  </tr>
                </tbody>
              </table>
              <div class="yj6qo"></div>
              <div class="adL"></div>
            </th>
          </tr>
          <tr><th style="background:#f5f5f1;height:28px"></th></tr>
          <tr><th style="background:#f5f5f1;height:28px"></th></tr>
        </tbody>
      </table>
    </div>
  </body>
</html>';

    $header = "From:vjrajchaudhary786@gmail.com \r\n";
    $header .= "MIME-Version: 1.0\r\n";
    $header .= "Content-type: text/html\r\n";

    return $retval = mail($to, $subject, $message, $header);
  }

}


if (!function_exists('createAppointmentConfirmEmail')) {

  function createAppointmentConfirmEmail($detail) {
    $data["data"] = $detail;
    $CI = setProtocol();
    $CI->email->from('noreply@.com', '');
    $CI->email->subject("Appointment Confirmation");
    $CI->email->message($CI->load->view('email/createappointmentmail', $data, TRUE));
    $CI->email->to($detail["email"]);
    $status = $CI->email->send();
    return $status;
  }

}

if (!function_exists('createAppointmentEmail')) {

  function createAppointmentEmail($detail) {
    $data["data"] = $detail;
    $CI = setProtocol();
    $CI->email->from('noreply@.com', '');
    $CI->email->subject("Appointment for you");
    $CI->email->message($CI->load->view('email/createappointmentmail', $data, TRUE));
    //$CI->email->message('appointmentmail');
    //$detail["email"]
    $CI->email->to($detail["email"]);
    $status = $CI->email->send();
    //echo $CI->email->print_debugger();

    return $status;
  }

}


if (!function_exists('sendShiftMemberMail')) {

  function sendShiftMemberMail($detail) {
    $CI = setProtocol();
    $CI->email->from('noreply@.com', '');
    $CI->email->subject($detail['subject']);
    $CI->email->message($detail['message']);
    $CI->email->to($detail["to"]);
    $status = $CI->email->send();
    return $status;
  }

}

if (!function_exists('sendcheckInEmail')) {

  function sendcheckInEmail($detail) {
    $data["data"] = $detail;
    $CI = setProtocol();
    $CI->email->from('noreply@.com', '');
    $CI->email->subject("Visitor check in");
    $CI->email->message($CI->load->view('email/checkinmail', $data, TRUE));
    //$CI->email->message('checkInmail');
    $CI->email->to($detail['email']);
    $status = $CI->email->send();

    return $status;
  }

}



if (!function_exists('sendnewticketEmail')) {

  function sendnewticketEmail($detail) {
    $data["data"] = $detail;
    $CI = setProtocol();
    $CI->email->from('noreply@.com', '');
    $CI->email->subject("New Ticket #" . $detail['ticketnumber']);
    $CI->email->message($CI->load->view('email/ticketassignemail', $data, TRUE));
    //$CI->email->message('Ticket assign');
    $CI->email->to($detail['email']);
    $status = $CI->email->send();

    return $status;
  }

}


if (!function_exists('sendticketstatusEmail')) {

  function sendticketstatusEmail($detail) {
    $data["data"] = $detail;
    $CI = setProtocol();
    $CI->email->from('noreply@.com', '');
    $subject = '#' . $detail['ticketId'] . ' Ticket - Status Changed';
    $CI->email->subject($subject);
    $CI->email->message($CI->load->view('email/ticketstatusemail', $data, TRUE));

    $toEmail = '';
    if (isset($detail['receivedUser']) && !empty($detail['receivedUser'])) {
      foreach ($detail['receivedUser'] as $usr) {
        $toEmail .= $usr['email'] . ',';
      }
    }
    $CI->email->to($toEmail);
    $status = $CI->email->send();

    return $status;
  }

}

if (!function_exists('sendticketcommentEmail')) {

  function sendticketcommentEmail($detail) {
    // error_reporting(-1);
    $data["data"] = $detail;
    $CI = setProtocol();
    $CI->email->from('noreply@.com', '');
    $subject = '#' . $detail['ticketId'] . ' Ticket - New Response';
    $CI->email->subject($subject);
    //$CI->email->subject(ucfirst($detail['commentUserName'])." comment on ticket #".$detail['ticketId']);
    $CI->email->message($CI->load->view('email/ticketcommentemail', $data, TRUE));
    //$CI->email->message('Comment by '.$detail['commentUserName']);
    $toEmail = '';
    if (isset($detail['receivedUser']) && !empty($detail['receivedUser'])) {
      foreach ($detail['receivedUser'] as $usr) {
        $toEmail .= $usr['email'] . ',';
      }
    }
    $CI->email->to($toEmail);
    $status = $CI->email->send();

    return $status;
  }

}

if (!function_exists('sendticketreminder')) {

  function sendticketreminder($detail) {

    $data["data"] = $detail;

    $CI = setProtocol();

    $CI->email->from('noreply@.com', '');

    $subject = '#' . $detail['ticketId'] . ' Ticket - Reminder';

    $CI->email->subject($subject);

    $CI->email->message($CI->load->view('email/ticketreminder', $data, TRUE));
    $CI->email->to($toEmail);
    $status = $CI->email->send();

    return $status;
  }

}

if (!function_exists('setFlashData')) {

  function setFlashData($status, $flashMsg) {
    $CI = get_instance();
    $CI->session->set_flashdata($status, $flashMsg);
  }

}


if (!function_exists('getLatestNotification')) {

  function getLatestNotification($userId) {
    $CI = get_instance();
    $CI->db->where('user_id', $userId);
    $CI->db->order_by('created_at', 'DESC');
    return $CI->db->get('tbl_notification')->result_array();
  }

}

if (!function_exists('getManPowerByOrgAndDept')) {

  function getManPowerByOrgAndDept($orgId, $deptId) {
    echo $orgId;
    echo $deptId;
    $CI = get_instance();
    $CI->db->select('tbl_users.*');
    $CI->db->where('organization_id', $orgId);
    $CI->db->where('department_id', $deptId);
    $this->db->where('tbl_users.isDeleted', '0');
    $data = $CI->db->get('tbl_users')->num_rows();
    //echo $CI->db->last_query();
    pre($data);
    die;
    return $data;
  }

}
?>
