<?php

if (!function_exists('get_instance')) {

  function get_instance() {
    $CI = &get_instance();
  }

}
if (!function_exists('secToTime')) {

  function secToTime($seconds) {

    $hours = floor($seconds / 3600);
    $mins = floor(($seconds - $hours * 3600) / 60);
    $s = $seconds - ($hours * 3600 + $mins * 60);

    $mins = ($mins < 10 ? "0" . $mins : "" . $mins);
    $s = ($s < 10 ? "0" . $s : "" . $s);

    return $time = ($hours > 0 ? $hours . ":" : "") . $mins . ":" . $s;
  }

}

if (!defined('BASEPATH'))
  exit('No direct script access allowed');



if (!function_exists('userFilterByRole')) {

  function userFilterByRole($userRole) {
    $data = [];
    if ($userRole == 'admin') {
      $data['qRole'] = 9;
      $data['qtype'] = "WH Admin";
    } elseif ($userRole == 'wm') {
      $data['qRole'] = 8;
      $data['qtype'] = "Warehouse Manager";
    } elseif ($userRole == 'all') {
      $data['qRole'] = 100;
      $data['qtype'] = "All Users";
    } elseif ($userRole == 'kam') {
      $data['qRole'] = 10;
      $data['qtype'] = "KAM";
    } elseif ($userRole == 'vp') {
      $data['qRole'] = 11;
      $data['qtype'] = "VP";
    } elseif ($userRole == 'supr') {
      $data['qRole'] = 4;
      $data['qtype'] = "Supervisor";
    } elseif ($userRole == 'hr') {
      $data['qRole'] = 5;
      $data['qtype'] = "HR";
    } elseif ($userRole == 'lh') {
      $data['qRole'] = 12;
      $data['qtype'] = "Location Head";
    } elseif ($userRole == 'assist-mngr') {
      $data['qRole'] = 13;
      $data['qtype'] = "Assistant Manager";
    } elseif ($userRole == 'shift-inch') {
      $data['qRole'] = 14;
      $data['qtype'] = "Shift Incharge";
    } elseif ($userRole == 'mngr') {
      $data['qRole'] = 2;
      $data['qtype'] = "Manager";
    } elseif ($userRole == 'sec') {
      $data['qRole'] = 15;
      $data['qtype'] = "Security";
    } else {
      $data['qRole'] = 3;
      $data['qtype'] = "Employee";
    }

    return $data;
  }

}
if (!function_exists('userFilterByRoleId')) {

  function userFilterByRoleId($userRoleId) {
    $data = [];
    if ($userRoleId == '9') {
      $data['qRole'] = 9;
      $data['qtype'] = "admin";
    } elseif ($userRoleId == '8') {
      $data['qRole'] = 8;
      $data['qtype'] = "wm";
    } elseif ($userRoleId == '100') {
      $data['qRole'] = 100;
      $data['qtype'] = "all";
    } elseif ($userRoleId == '10') {
      $data['qRole'] = 10;
      $data['qtype'] = "kam";
    } elseif ($userRoleId == '11') {
      $data['qRole'] = 11;
      $data['qtype'] = "vp";
    } elseif ($userRoleId == '4') {
      $data['qRole'] = 4;
      $data['qtype'] = "supr";
    } elseif ($userRoleId == '5') {
      $data['qRole'] = 5;
      $data['qtype'] = "hr";
    } elseif ($userRoleId == '12') {
      $data['qRole'] = 12;
      $data['qtype'] = "lh";
    } elseif ($userRoleId == '13') {
      $data['qRole'] = 13;
      $data['qtype'] = "assist-mngr";
    } elseif ($userRoleId == '14') {
      $data['qRole'] = 14;
      $data['qtype'] = "shift-inch";
    } elseif ($userRoleId == '2') {
      $data['qRole'] = 2;
      $data['qtype'] = "mngr";
    } elseif ($userRoleId == '15') {
      $data['qRole'] = 15;
      $data['qtype'] = "sec";
    } else {
      $data['qRole'] = 3;
      $data['qtype'] = "emp";
    }

    return $data;
  }

}

//if (!function_exists('departmentByUser')) {
//
//  function departmentByUser() {
//    $userId = $this->session->userdata('userId');
//    $CI = get_instance();
//    $CI->db->select('dept_id,dept_name');
//    $CI->db->where('org_id', $userId);
//    $CI->db->where('dept_name', 'UTF');
//    $CI->db->or_where('dept_name', 'utf');
//    $CI->db->or_where('isDeleted', '0');
//    $data = $this->db->get('tbl_departments')->row_array();
//    //pre($data);
//  }
//
//}

if (!function_exists('utfDepartmentByOrg')) {

  function utfDepartmentByOrg() {
    $CI = get_instance();
    $orgId = $CI->session->userdata('organization_id');
    $CI->db->select('tbl_sub_departments.id, tbl_sub_departments.sub_dept_name,tbl_departments.dept_id,tbl_departments.dept_name');
    $CI->db->where('tbl_departments.org_id', $orgId);
    $CI->db->where('tbl_departments.dept_name', 'FTU');
    $CI->db->where('tbl_sub_departments.sub_dept_name', 'FTU');
    $CI->db->where('tbl_departments.isDeleted', '0');
    $CI->db->where('tbl_sub_departments.isDeleted', '0');
    $CI->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_sub_departments.dept_id', 'righ');
    $data = $CI->db->get('tbl_sub_departments')->row_array();
//    last_query();
    return $data;
  }

}

if (!function_exists('departmentByUser')) {

  function departmentByUser($userId) {
    $userId;
//$userId = $this->session->userdata('userId');
    $CI = get_instance();
    $CI->db->select('dept_id as department_id,sub_dept_id as sub_department_id,shift_mgmt.*');
    $CI->db->where('superviser_id', $userId);
//$CI->db->where('dept_name', 'UTF');
//$CI->db->or_where('dept_name', 'utf');
//$CI->db->or_where('isDeleted', '0');
    return $data = $CI->db->get('shift_mgmt')->row_array();
//return $data['sub_department_id'];
  }

}
if (!function_exists('isEmpInFTUAlreadyToday')) {

  function isEmpInFTUAlreadyToday($empId, $ftuDeptArray) {
//    pre($ftuDeptArray);
//    $userId;
//$userId = $this->session->userdata('userId');
    $CI = get_instance();
    $CI->db->select('*');
    $CI->db->where('user_id', $empId);
    $CI->db->where('org_id', $CI->session->userdata('organization_id'));
    $CI->db->where('dept_id', $ftuDeptArray['dept_id']);
    $CI->db->where('sub_dept_id', $ftuDeptArray['id']);
    $CI->db->where('status', '3');
    $CI->db->like('check_in', date('Y-m-d'), 'after');
//$CI->db->where('dept_name', 'UTF');
//$CI->db->or_where('dept_name', 'utf');
//$CI->db->or_where('isDeleted', '0');
    $data = $CI->db->get('working_logs')->row_array();
//    last_query();
//    pre($data);
    if (count($data) > 1) {
      return TRUE;
    } else {
      return FALSE;
    }
  }

}
if (!function_exists('clientName')) {

  function clientName($clientId) {
    $CI = get_instance();
    $CI->db->select('client');
    $CI->db->where('id', $clientId);
    return $data = $CI->db->get('tbl_clients')->row()->client;
  }

}

if (!function_exists('shiftName')) {

  function shiftName($shiftId) {
    $CI = get_instance();
    $CI->db->select('shift_name');
    $CI->db->where('id', $shiftId);
    return $data = $CI->db->get('tbl_shift')->row()->shift_name;
  }

}
if (!function_exists('locationName')) {

  function locationName($locId) {
    $CI = get_instance();
    $CI->db->select('loc_name');
    $CI->db->where('loc_id', $locId);
    return $data = $CI->db->get('tbl_location')->row()->loc_name;
  }

}
if (!function_exists('orgName')) {

  function orgName($orgId) {
    $CI = get_instance();
    $CI->db->select('org_name');
    $CI->db->where('id', $orgId);
    return $data = $CI->db->get('tbl_organization')->row()->org_name;
  }

}
if (!function_exists('deptName')) {

  function deptName($deptId) {
    if ($deptId == 'all') {
      return 'All';
    }
    $CI = get_instance();
    $CI->db->reset_query();
    $CI->db->select('dept_name');
    $CI->db->where('dept_id', $deptId);
    return $data = $CI->db->get('tbl_departments')->row()->dept_name;
  }

}
if (!function_exists('subDeptName')) {

  function subDeptName($subDeptId) {
    $CI = get_instance();
    $CI->db->select('sub_dept_name');
    $CI->db->where('id', $subDeptId);
    return $data = $CI->db->get('tbl_sub_departments')->row()->sub_dept_name;
  }

}
if (!function_exists('empNameById')) {

  function empNameById($empId) {
    $CI = get_instance();
    $CI->db->select('name');
    $CI->db->where('userId', $empId);
    return $data = $CI->db->get('tbl_users')->row()->name;
  }

}
if (!function_exists('shiftNameBySubDeptId')) {

  function shiftNameBySubDeptId($subDeptId) {
    $CI = get_instance();
    $CI->db->select('shift');
    $CI->db->where('id', $subDeptId);
    return $data = $CI->db->get('tbl_sub_departments')->row()->shift;
  }

}
if (!function_exists('shiftNameBySupervisor')) {

  function shiftNameBySupervisor($supervisorId) {
    $CI = get_instance();
    $CI->db->select('tbl_shift.shift_name');
    $CI->db->where('shift_mgmt.superviser_id', $supervisorId);
    $CI->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'right');
    return $data = $CI->db->get('shift_mgmt')->row()->shift_name;
  }

}
if (!function_exists('subDeptIdBySupervisor')) {

  function subDeptIdBySupervisor($supervisorId) {
    $CI = get_instance();
    $CI->db->select('shift_mgmt.*');
    $CI->db->where('shift_mgmt.superviser_id', $supervisorId);
    return $data = $CI->db->get('shift_mgmt')->row()->sub_dept_id;
  }

}
if (!function_exists('superviserBySubDeptId')) {

  function superviserBySubDeptId($subDeptId) {
    $subDeptId;
    $CI = get_instance();
    $CI->db->where('sub_department_id', $subDeptId);
    $CI->db->where('roleId', '4');
    return $data = $CI->db->get('tbl_users')->row()->name;
  }

}
if (!function_exists('clientIdByLocationId')) {

  function clientIdByLocationId($locationId) {
    $CI = get_instance();
    $clientIdsArray = array();
    if (isset($locationId) && is_array($locationId)) {
      $CI->db->where_in('loc_id', $locationId);
      $CI->db->group_by('client_id');
      $dataArray = $CI->db->get('tbl_location')->result();
      if (isset($dataArray) && !empty($dataArray) && is_array($dataArray)) {
        foreach ($dataArray as $data) {
          $clientIdsArray[] = $data->client_id;
        }
      }
      return $clientIdsArray;
    }
    $CI->db->where('loc_id', $locationId);
    return $data = $CI->db->get('tbl_location')->row()->client_id;
  }

}
if (!function_exists('clientArrayByLocationId')) {

  function clientArrayByLocationId($locationId) {
    $CI = get_instance();
    $clientIdsArray = array();
    if (isset($locationId) && is_array($locationId)) {
      $CI->db->where_in('loc_id', $locationId);
      $CI->db->group_by('client_id');
      return $dataArray = $CI->db->get('tbl_location')->result();
      if (isset($dataArray) && !empty($dataArray) && is_array($dataArray)) {
        foreach ($dataArray as $data) {
          $clientIdsArray[] = $data->client_id;
        }
      }
      return $clientIdsArray;
    }
//$CI->db->where('loc_id', $locationId);
//return $data = $CI->db->get('tbl_location')->row()->client_id;
  }

}
if (!function_exists('locationIdByOrgId')) {

  function locationIdByOrgId($orgId) {
    $CI = get_instance();
    $CI->db->where('id', $orgId);
    return $data = $CI->db->get('tbl_organization')->row()->loc_id;
  }

}
if (!function_exists('empIdByEmpCode')) {

  function empIdByEmpCode($empCode) {
    $CI = get_instance();
    $CI->db->where('emp_code', $empCode);
    return $data = $CI->db->get('tbl_users')->row()->userId;
  }

}

if (!function_exists('empCodeByEmpId')) {

  function empCodeByEmpId($empId) {
    $CI = get_instance();
    $CI->db->where('userId', $empId);
    return $data = $CI->db->get('tbl_users')->row()->emp_code;
  }

}
if (!function_exists('isPresent')) {

  function isPresent($empCode) {
    $CI = get_instance();
    $CI->db->where('emp_code', $empCode);
    return $data = $CI->db->get('tbl_users')->row()->current_status;
  }

}
if (!function_exists('shiftTimeBySubDept')) {

  function shiftTimeBySubDept($subDeptId) {
    $CI = get_instance();
    $CI->db->where('id', $subDeptId);
    return $data = $CI->db->get('tbl_sub_departments')->row();
  }

}
if (!function_exists('getShiftMngtBySupervisor')) {

  function getShiftMngtBySupervisor($supervisorId, $dept = '', $sub_dept = '') {
    $CI = &get_instance();
    $where = '';
    if ($dept != '') {
      $where = ' AND dept_id = ' . $dept;
    }
    if ($sub_dept != '') {
      $where = ' AND sub_dept_id = ' . $sub_dept;
    }
    $selectQuery = 'SELECT * ,SEC_TO_TIME((TIME_TO_SEC(out_time) - TIME_TO_SEC(in_time))) AS `total_hours`,(TIME_TO_SEC(out_time) - TIME_TO_SEC(in_time)) AS `total_sec_to_work`'
        . ' from shift_mgmt'
        . ' WHERE superviser_id = ' . $supervisorId . ' AND isDeleted = 0 ' . $where;
    $query = $CI->db->query($selectQuery);
    return $employees = $query->row_array();
  }

}

//if (!function_exists('getShiftMngtBySupervisor')) {
//
//  function getShiftMngtBySupervisor($supervisorId, $dept = '', $sub_dept = '') {
//    $CI = &get_instance();
//    $where = '';
//    if ($dept != '') {
//      $where = ' AND dept_id = ' . $dept;
//    }
//    if ($sub_dept != '') {
//      $where = ' AND sub_dept_id = ' . $sub_dept;
//    }
//    $selectQuery = 'SELECT * ,SEC_TO_TIME((TIME_TO_SEC(out_time) - TIME_TO_SEC(in_time))) AS `total_hours`'
//        . ' from shift_mgmt'
//        . ' WHERE superviser_id = ' . $supervisorId . ' AND isDeleted = 0 ' . $where;
//    $query = $CI->db->query($selectQuery);
//    return $employees = $query->row_array();
//  }
//
//}
if (!function_exists('getWorkingLogs')) {

  function getWorkingLogs($supervisorId, $empId) {
    $CI = &get_instance();
    $deptArray = departmentByUser($supervisorId);
    $departmentId = $deptArray['department_id'];
    $subDepartmentId = $deptArray['sub_department_id'];
    $orgId = $deptArray['org_id'];
    date_default_timezone_set("Asia/Calcutta");   //India time (GMT+5:30)
    $todayDate = date('Y-m-d');
//    $client_list = $this->db->from('tbl_clients')->get()->result_array();
    //$all_employees = $this->db->query('SELECT U.userId, U.name, U.emp_id, U.emp_code, (SELECT dept_name FROM tbl_departments WHERE dept_id=U.department_id) AS department_name FROM tbl_users AS U WHERE userId IN (SELECT employee_id FROM tbl_manpower_team_members WHERE shift_over = \'0\' AND manpower_team_id=' . $this->input->post('team_id') . ')')->result();
    $currentStatus = "'1'";
    $selectQuery = 'SELECT '
        . ' wl.check_in, '
        . ' wl.check_out, '
        . 'SEC_TO_TIME((TIME_TO_SEC(wl.check_out) - TIME_TO_SEC(wl.check_in))) AS `total_hours`,'
        . 'U.roleId AS user_role,'
        . 'U.designation, '
        . 'U.userId AS user_id, '
        . 'U.name AS employee_name, '
        . 'U.email AS employee_email, '
        . 'U.userId AS employee_id, '
        . 'U.emp_code AS employee_code'
        . '  FROM tbl_users AS U '
//            . ' Left Join working_logs on working_logs.superviser_id = U.userId'
        . ' Left Join working_logs wl on wl.user_id = U.userId'
        . ' WHERE U.current_status = ' . $currentStatus . ' AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' AND U.userId != ' . $empId . ' and organization_id = ' . $orgId . ' and U.roleId = 3 and wl.check_in like "' . $todayDate . '%"';

    $query = $CI->db->query($selectQuery);
    return $employees = $query->row_array();
  }

}
if (!function_exists('subDeptMngtByShifMngtId')) {

  function subDeptMngtByShifMngtId($shiftMngtId) {
    $CI = &get_instance();
    $selectQuery = 'SELECT * ,LOWER(uom.name)as name'
        . ' from tbl_sub_dept_mngt'
        . ' left join uom on uom.id = tbl_sub_dept_mngt.uom_id'
        . ' WHERE shift_mngt_id = ' . $shiftMngtId . ' AND tbl_sub_dept_mngt.isDeleted = 0 ';
    $query = $CI->db->query($selectQuery);
    return $employees = $query->row_array();
  }

}
if (!function_exists('subDeptMngtByShifMngtId')) {

  function subDeptMngtByShifMngtId($shiftMngtId, $dept = '', $subDept = '') {
    $CI = &get_instance();
    $where = '';
    if ($subDept != '') {
      $where .= ' AND dept_id = ' . $dept;
    }
    if ($dept != '') {
      $where .= ' AND sub_dept_id = ' . $subDept;
    }
    echo $selectQuery = 'SELECT * ,LOWER(uom.name)as name'
    . ' from tbl_sub_dept_mngt'
    . ' left join uom on uom.id = tbl_sub_dept_mngt.uom_id'
    . ' WHERE shift_mngt_id = ' . $shiftMngtId . ' AND tbl_sub_dept_mngt.isDeleted = 0 ' . $where;
    die;
    $query = $CI->db->query($selectQuery);
    return $employees = $query->row_array();
  }

}
if (!function_exists('isEmployeeInTeam')) {

  function isEmployeeInTeam($post) {
//    pre($post);
    $CI = get_instance();
//    pre($CI);
    $userId = $CI->session->userdata('userId');
//    pre($CI->session->userdata());
//    die;
    $mngtArray = getShiftMngtBySupervisor($userId);
//    pre($mngtArray);
    $orgId = $mngtArray['org_id'];

//    pre($post);
    $clientId = $post['client'];
    $departmentId = $post['department_id'];
    $subDepartmentId = $post['sub_department_id'];
    $shiftId = $post['shift'];
//    pre($post);
    $clientList = findKeysArrayInArray(clientsListArray($CI->session->userdata('userId'), 'array'));
    $deptList = findKeysArrayInArray(departmentList($CI->session->userdata('userId'), 'array'));
    $subDeptList = findKeysArrayInArray(subDepartmentList($CI->session->userdata('userId'), 'array'));
    $shiftList = findKeysArrayInArray(shiftList($CI->session->userdata('userId'), 'array'));

    if ($post['type'] == 'filter') {
      $where = 'AND U.reporting_manager = ' . $userId . '  AND U.sub_department_id = ' . $subDepartmentId . ' AND U.department_id = ' . $departmentId . ' AND U.client_id = ' . $clientId . ' AND U.shift = ' . $shiftId . '  and organization_id = ' . $orgId . ' and U. roleId = 3';
    } else {
      $where = 'AND U.reporting_manager = ' . $userId . '  AND U.sub_department_id in( ' . implode(', ', $subDeptList) . ') AND U.department_id in( ' . implode(', ', $deptList) . ') AND U.client_id in( ' . implode(', ', $clientList) . ') AND U.shift in( ' . implode(', ', $shiftList) . ') and organization_id = ' . $orgId . ' and U. roleId = 3';
    }

//    echo $where;
//    die;

    $selectQuery = 'SELECT '
        . ' '
        . 'U.client_id, '
        . 'U.department_id, '
        . 'U.sub_department_id, '
        . 'U.shift, '
        . 'U.roleId AS user_role, '
        . 'U.designation, '
        . 'U.userId AS user_id, '
        . 'U.name AS employee_name, '
        . 'U.email AS employee_email, '
        . 'U.emp_id AS employee_id, '
        . 'U.emp_code AS employee_code, '
        . 'U.department_id, U.current_status, '
        . '(SELECT dept_name from `tbl_departments` where `dept_id` = department_id) as department_name, '
        . '(SELECT sub_dept_name from `tbl_sub_departments` where `id` = sub_department_id) as sub_department_name FROM tbl_users AS U '
        . 'WHERE U.userId != ' . $userId . ' AND U.current_status != 0 ' . $where;
    return $all_team_employees = $CI->db->query($selectQuery)->result();
//    last_query();
//return $data = $CI->db->get('tbl_sub_departments')->row();
  }

}

if (!function_exists('findKeysArrayInArray')) {

  function findKeysArrayInArray($associativeArray) {
//    pre($associativeArray);
    $resultArray = [];
    foreach ($associativeArray as $key => $value) {
      $avalue = array_values($value);
      $resultArray[] = $avalue['0'];
    }

    return $resultArray;
//    foreach ($associativeArray as $array) {
//      $resultArray = $array['dept_id'];
////      pre($array);
//    }
  }

}

if (!function_exists('freeToUseEmp')) {

  function freeToUseEmp() {
    $CI = get_instance();
    $userId = $CI->session->userdata('userId');
    $departmentId = $CI->session->userdata('department_id');
    $subDepartmentId = $CI->session->userdata('sub_department_id');
    $orgId = $CI->session->userdata('organization_id');
    $selectQuery = 'SELECT '
        . ' '
        . 'U.roleId AS user_role, '
        . 'U.designation, '
        . 'U.userId AS user_id, '
        . 'U.name AS employee_name, '
        . 'U.email AS employee_email, '
        . 'U.emp_id AS employee_id, '
        . 'U.emp_code AS employee_code, '
        . 'U.department_id, U.current_status, '
        . '(SELECT dept_name from `tbl_departments` where `dept_id` = department_id) as department_name, '
        . '(SELECT sub_dept_name from `tbl_sub_departments` where `id` = sub_department_id) as sub_department_name FROM tbl_users AS U '
        . 'WHERE U.userId != ' . $userId . ' AND U.current_status = "0" and organization_id = ' . $orgId . ' and U. roleId = 3';
    return $all_team_employees = $CI->db->query($selectQuery)->result();
    //die;
//return $data = $CI->db->get('tbl_sub_departments')->row();
  }

}

if (!function_exists('productivityHour')) {

  function productivityHour($date2, $date1) {

    $diff = abs(strtotime($date2) - strtotime($date1));
    $years = floor($diff / (365 * 60 * 60 * 24));
    $months = floor(($diff - $years * 365 * 60 * 60 * 24) / (30 * 60 * 60 * 24));
    $days = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24) / (60 * 60 * 24));
    $hours = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24) / (60 * 60));
    $minuts = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24 - $hours * 60 * 60) / 60);
    $seconds = floor(($diff - $years * 365 * 60 * 60 * 24 - $months * 30 * 60 * 60 * 24 - $days * 60 * 60 * 24 - $hours * 60 * 60 - $minuts * 60));
    return $hours . ':' . $minuts . ':' . $seconds;
  }

}

/**
 * This function is used to check whether email id is already exist or not
 * @param {string} $email : This is email id
 * @param {number} $userId : This is user id
 * @return {mixed} $result : This is searched result
 */
function checkEmailExists($email, $userId = 0) {
  $CI = get_instance();
  $CI->db->select("email");
  $CI->db->from("tbl_users");
  $CI->db->where("email", $email);
  $CI->db->where("isDeleted", 0);
  if ($userId != 0) {
    $CI->db->where("userId !=", $userId);
  }
  $query = $CI->db->get();

  $result = $query->result();
  if (empty($result)) {
    return 1;
  } else {
    return 0;
  }
}

function checkEmployeecode($empcode, $userId = 0) {
  $CI = get_instance();
  $CI->db->select("emp_code");
  $CI->db->from("tbl_users");
  $CI->db->where("emp_code", $empcode);
  $CI->db->where("isDeleted", 0);
  if ($userId != 0) {
    $CI->db->where("userId !=", $userId);
  }
  $query = $CI->db->get();

  $result = $query->result();
  if (empty($result)) {
    return 1;
  } else {
    return 0;
  }
}

function isThisUsed($where, $table) {
  $CI = get_instance();
  $CI->db->select("*");
  $CI->db->from($table);
  $CI->db->where($where);
//  $CI->db->where("isDeleted", 0);
//  if ($userId != 0) {
//    $CI->db->where("userId !=", $userId);
//  }
  $query = $CI->db->get();

  $result = $query->result();
  if (empty($result)) {
    return 0;
  } else {
    return 1;
  }
}

function isUserHeaderOK($worksheet) {
  if ($worksheet->getCellByColumnAndRow(0, 1)->getValue() == "Employee Name" && $worksheet->getCellByColumnAndRow(1, 1)->getValue() == "Email" && $worksheet->getCellByColumnAndRow(2, 1)->getValue() == "Mobile No" && $worksheet->getCellByColumnAndRow(3, 1)->getValue() == "Designation" && $worksheet->getCellByColumnAndRow(4, 1)->getValue() == "Employee Code" && $worksheet->getCellByColumnAndRow(5, 1)->getValue() == "Skills") {
    return 'TRUE';
  } else {
    return 'FALSE';
  }
}

function isProHeaderOK($worksheet) {
  if ($worksheet->getCellByColumnAndRow(0, 1)->getValue() == "Employee Code" && $worksheet->getCellByColumnAndRow(1, 1)->getValue() == "Shift" && $worksheet->getCellByColumnAndRow(2, 1)->getValue() == "Challan" && $worksheet->getCellByColumnAndRow(3, 1)->getValue() == "Boxes" && $worksheet->getCellByColumnAndRow(4, 1)->getValue() == "Qty" && $worksheet->getCellByColumnAndRow(5, 1)->getValue() == "SKU" && $worksheet->getCellByColumnAndRow(6, 1)->getValue() == "KG" && $worksheet->getCellByColumnAndRow(7, 1)->getValue() == "CFC" && $worksheet->getCellByColumnAndRow(8, 1)->getValue() == "BINS" && $worksheet->getCellByColumnAndRow(9, 1)->getValue() == "PALLET") {
    return 'TRUE';
  } else {
    return 'TRUE';
  }
}

if (!function_exists('clientsList')) {

  function clientsList($clientsString) {
    if (isset($clientsString) && !empty($clientsString)) {
      $clientName = "<td>";
      $clientsArray = explode(',', $clientsString);
      for ($i = 0; $i < count($clientsArray); $i++) {
        $clientName .= clientName($clientsArray[$i]) . " <br>";
      }
      return $clientName .= "</td>";
    } else {
      return $clientName = "<td> NA </td>";
    }
  }

}


if (!function_exists('supervisersBySubDeptId')) {

  function supervisersBySubDeptId($subDeptId) {

    $CI = get_instance();

    $CI->db->select('tbl_users.userId, tbl_users.name');
    $CI->db->where('organization_id', $CI->session->userdata('organization_id'));
    $CI->db->where('createdBy', $CI->session->userdata('userId'));
    $CI->db->where('roleId', '4');
    return $data = $CI->db->get('tbl_users')->result_array();
  }

}
if (!function_exists('allShiftList')) {

  function allShiftList() {
    $CI = get_instance();
    $CI->db->select('tbl_shift.id, tbl_shift.shift_name');
    $CI->db->where('isDeleted', '0');
    return $data = $CI->db->get('tbl_shift')->result_array();
  }

}
if (!function_exists('getUOMList')) {

  function getUOMList() {
    $CI = get_instance();
    $CI->db->select('uom.*');
    $CI->db->where('isDeleted', '0');
    return $data = $CI->db->get('uom')->result_array();
  }

}

if (!function_exists('shiftMngtByDeptIdSubDeptId')) {

  function shiftMngtByDeptIdSubDeptId($deptId, $subDeptId) {
    $CI = get_instance();
    $CI->db->select('shift_mgmt.*, shift_mgmt.in_time, shift_mgmt.out_time, tbl_shift.shift_name');
    $CI->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $CI->db->where('shift_mgmt.dept_id', $deptId);
    $CI->db->where('shift_mgmt.sub_dept_id', $subDeptId);
    //$CI->db->where('shift_mgmt.status', '1');
    $CI->db->where('shift_mgmt.org_id', $CI->organization_id);
    $data = $CI->db->get('shift_mgmt')->result_array();
    //last_query();
    return $data;
  }

}

if (!function_exists('getAllShiftMngtToStart')) {

  function getAllShiftMngtToStart() {
    date_default_timezone_set("Asia/Calcutta");   //India time (GMT+5:30)
    $currentTime = date('H:i');
    // $currentTime = '09:00';
    $CI = get_instance();
    $CI->db->select('shift_mgmt.*,tbl_sub_dept_mngt.client_id, tbl_shift.shift_name');
    $CI->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $CI->db->join('tbl_sub_dept_mngt', 'tbl_sub_dept_mngt.shift_mngt_id = shift_mgmt.id', 'right');
    $CI->db->like('shift_mgmt.in_time', $currentTime, 'after');
    $data = $CI->db->group_by('shift_mgmt.id')->get('shift_mgmt')->result_array();
    // pre($data);
    return $data;
  }

}
if (!function_exists('getAllShiftMngtToFinish')) {

  function getAllShiftMngtToFinish() {
    date_default_timezone_set("Asia/Calcutta");   //India time (GMT+5:30)
    $currentTime = date('H:i');
//    $currentTime = '17:30';
    $CI = get_instance();
    $CI->db->select('shift_mgmt.*, tbl_shift.shift_name');
    $CI->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    $CI->db->like('shift_mgmt.out_time', $currentTime, 'after');
    $data = $CI->db->get('shift_mgmt')->result_array();
    return $data;
  }

}


if (!function_exists('getOrganizedClient')) {

  function getOrganizedClient() {
    $CI = get_instance();
    $clientsString = $CI->session->userdata('client_id');
//    pre($clientsString);

    $clientArray = explode(',', $clientsString);
    $clientListArray = [];
    foreach ($clientArray as $key => $value) {
      $clientListArray[$key]['client_id'] = $value;
      $clientListArray[$key]['id'] = $value;
      $clientListArray[$key]['client'] = clientName($value);
    }
    return $clientListArray;
  }

}
if (!function_exists('clientsByClientsArray')) {

  function clientsByClientsArray($clientsArray) {
    $CI = get_instance();
    $CI->db->select('tbl_clients.*');
    $CI->db->where_in('tbl_clients.id', array_values($clientsArray));
    $data = $CI->db->get('tbl_clients')->result_array();
    return $data;
  }

}

function getDatesFromRange($start, $end, $format = 'Y-m-d') {
  $array = array();
  $interval = new DateInterval('P1D');

  $realEnd = new DateTime($end);
  $realEnd->add($interval);

  $period = new DatePeriod(new DateTime($start), $interval, $realEnd);

  foreach ($period as $date) {
    $array[] = $date->format($format);
  }

  return $array;
}

?>
