<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <i class="fa fa-users"></i> Employee Management
      <small>Add / Edit Employee</small>
    </h1>
  </section>

  <section class="content">

    <div class="row">
      <!-- left column -->
      <div class="col-md-8">
        <!-- general form elements -->



        <div class="box box-primary">
          <div class="box-header">
            <h3 class="box-title">Enter User Details</h3>
          </div><!-- /.box-header -->
          <!-- form start -->
          <?php $this->load->helper("form"); ?>
          <form id="addUser1"  action="<?php echo base_url() ?>addNewUser" onsubmit="return addNewUserForm()" method="post" role="form" enctype="multipart/form-data">
            <div class="box-body">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="fname">Full Name</label>
                    <input type="text" class="form-control required" required value="<?php echo set_value('fname'); ?>" id="fname" name="fname" maxlength="128">
                  </div>

                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" class="form-control required email" onblur="checkUniqueMail()" required id="email" value="<?php echo set_value('email'); ?>" name="email" maxlength="128">
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="mobile">Mobile No.</label>
                    <input type="text" class="form-control required digits" required pattern="^\d{10}$" title="Please enter 10 digit valid mobile number" id="mobile" value="<?php echo set_value('mobile'); ?>" name="mobile" maxlength="10">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="role">Skills</label>
                    <!-- <input type="text" class="form-control required" required name="skills" id="skills" > </input> -->
                    <select class="form-control" multiple="multiple" name="skills[]" id="skills"></select>
                  </div>
                </div>
                

              </div>

              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="organization">Warehouse Name</label>
                    <select class="form-control required" id="organization" required="" name="organization" onchange="getdepartmentlist(this.value)">
                      <option value="">Select Warehouse</option>
                      <?php if (isset($organizationList)) { ?>
                        <?php foreach ($organizationList as $key => $org) { ?>
                          <option <?php
                          if (!in_array($this->role, ['9', '10', '11', '12'])) {
                            echo 'selected';
                          }
                          ?> value="<?php echo $org['id'] ?>"><?php echo $org['org_name']; ?></option>
                          <?php } ?>
                        <?php } ?>
                    </select>
                  </div>
                </div>
                <?php if (!in_array($addUserRoleType, array('lh', 'kam', 'vp', 'wm', 'admin'))) { ?>

                  <!--                  <div class="col-md-6">
                                      <div class="form-group">
                                        <label for="department">Department</label>
                                        <input type="text" autocomplete="off" name="department" id="department" value="<?php echo $emailId; ?>" class="form-control" placeholder="Department"/>
                                      </div>
                                    </div>-->
                <?php } ?>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="role">Role</label>

                    <select class="form-control required" required="" id="role" name="role">
                      <option value="3" data-role-priority = "4">Employee</option>
                    </select>
                  </div>
                </div>

              </div>
              <div class="row">




              </div>
              <div class="row" id="shift_div">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="shift">Shift</label>
                    <!-- //onchange="checkPreviousSuperVisor(this.value,'')" -->
                    <select class="form-control" id="shift" name="shift" >
                      <option value="">--Select--</option>
                      <option value="A">A</option>
                      <option value="B">B</option>
                      <option value="C">C</option>
                      <option value="D">D</option>
                      <option value="E">E</option>
                      <option value="F">F</option>
                      <option value="G">G</option>
                      <option value="H">H</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-6"></div>
              </div>
              <div class="row">

                <div class="col-md-6">
                  <div class="form-group">
                    <label for="designation">Designation</label>
                    <input type="text" class="form-control required" required name="designation" id="designation" required=""> </input>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="emp_code">Employee code</label>
                    <!-- <input type="text" class="form-control required" required name="skills" id="skills" > </input> -->
                    <input type="text" class="form-control" required onblur="checkEmployeeCode(this)" name="emp_code" id="emp_code" > </input>
                  </div>
                </div>
              </div>
              <div class="row">

                
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="role">Profile Photo</label>
                    <input type="file" accept="image/*" class="form-control" name="avatar" id="avatar"> </input>
                  </div>
                </div>

              </div>
            </div><!-- /.box-body -->

            <div class="box-footer">
              <input type="submit" id="submitBth" class="btn btn-primary" value="Submit" />
              <input type="reset" class="btn btn-default" value="Reset" />
            </div>
          </form>
        </div>
      </div>
      <div class="col-md-4">
        <?php
        $this->load->helper('form');
        $error = $this->session->flashdata('error');
        if ($error) {
          ?>
          <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('error'); ?>
          </div>
        <?php } ?>
        <?php
        $success = $this->session->flashdata('success');
        if ($success) {
          ?>
          <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <?php echo $this->session->flashdata('success'); ?>
          </div>
        <?php } ?>

        <div class="row">
          <div class="col-md-12">
            <?php echo validation_errors('<div class="alert alert-danger alert-dismissable">', ' <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button></div>'); ?>
          </div>
        </div>
      </div>
    </div>
  </section>

</div>
<script src="<?php echo base_url(); ?>assets/js/addUser.js" type="text/javascript"></script>
<div class="modal" id="adddepartmentmodel">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header listingtable-head">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Add New Department</h4>
      </div>
      <!-- Modal body -->
      <form action="" type="post" onsubmit="return addNewDepartment()">
        <div class="modal-body">

          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="fname">Organization Name</label>
                <select class="form-control required" id="organizationm" name="organizationm" required="">
                  <option value="">Select Organization</option>
                  <?php if (isset($organizationList)) { ?>
                    <?php foreach ($organizationList as $key => $org) { ?>
                      <option value="<?php echo $org['id'] ?>"><?php echo $org['org_name']; ?></option>
                    <?php } ?>
                  <?php } ?>
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label for="email">Department Name</label>
                <input type="text" class="form-control" id="deptnamem" value="" name="deptnamem" maxlength="128" required="">
              </div>
            </div>
          </div>

        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="form-group">
              <p class="alert-msg"></p>
            </div>
          </div>
        </div>
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Add</button>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </form>
    </div>
  </div>
</div>


<div class="modal" id="changeRoleModel">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Change Role</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div><p>First Change the supervisor role of below employee</p></div>
      <!-- Modal body -->
      <div class="modal-body change-role-section">

      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>

    </div>
  </div>
</div>
<script>
  $("#organization").select2({
  });
  $("#role").select2({
  });

  $(document).ready(function () {
    var max_fields = 10; //maximum input boxes allowed
    var wrapper = $(".input_fields_wrap"); //Fields wrapper
    var add_button = $(".add_field_button"); //Add button ID

    var x = 1; //initlal text box count
    $(add_button).click(function (e) { //on add input button click
      e.preventDefault();
      if (x < max_fields) { //max input box allowed
        x++; //text box increment
        $(wrapper).append('<div><input type="text" name="mytext[]"/><a href="#" class="remove_field">Remove</a></div>'); //add input box
      }
    });

    $(wrapper).on("click", ".remove_field", function (e) { //user click on remove text
      e.preventDefault();
      $(this).parent('div').remove();
      x--;
    })
  });

</script>
