/**
 * File : manpowerCreateTeam.js
 *
 * This file contain the validation of add user form
 *
 * Using validation plugin : jquery.validate.js
 *
 * @author Rohit Sidhwani
 */
$(document).ready(function () {

//setInterval(function(){get_employees_to_be_added_table_markup();}, 1000);

  $('#create-team-form').on('submit', function () {

    return validate_create_team_form();
  });
  get_added_employees_table_markup('all');
  get_employees_to_be_added_table_markup();
  $('#shift_start_hour').on('change', function () {

    var shift_start_hour = $(this).val();
    var shift_start_minute = $('#shift_start_minute').val();
    if (shift_start_hour !== '' && shift_start_minute !== '') {

      $.ajax({

        type: 'POST',
        async: false,
        url: baseURL + 'save_shift_start_time',
        data: {
          hour: shift_start_hour,
          minute: shift_start_minute,
          team_id: $('#team_id').val()
        },
        async: false,
        success: function (response) {

          window.location.href = baseURL + 'create-team';
        }
      });
    }
  });
  $('#shift_start_minute').on('change', function () {

    var shift_start_hour = $('#shift_start_hour').val();
    var shift_start_minute = $(this).val();
    if (shift_start_hour !== '' && shift_start_minute !== '') {

      $.ajax({

        type: 'POST',
        async: false,
        url: baseURL + 'save_shift_start_time',
        data: {
          hour: shift_start_hour,
          minute: shift_start_minute,
          team_id: $('#team_id').val()
        },
        async: false,
        success: function (response) {

          window.location.href = baseURL + 'create-team';
        }
      });
    }
  });
});
function save_shift(shift_selection) {

  $('#shift_selection_input').val(shift_selection);
  $('#save_shift_form').submit();
}

function save_client(client_selection) {
  var shift = $("#shift_selection").val();
  if (shift == '') {
    alert('Please select the shift first');
    $("#client_selection").val('');
  } else {
//  alert(client_selection);
    $('#client_selection_input').val(client_selection);
    $('#save_client_form').submit();
  }

}

function get_added_employees_table_markup(type) {

  start_loader();
  var shift = $('#shift_selection').val();
  var client = $('#client_selection').val();
  if (shift != '') {
    $.ajax({
      type: 'POST',
      async: false,
      url: baseURL + 'getAddedEmployeesTableMarkup',
      //url: baseURL + 'get_added_employees_table_markup',
      data: {
        type: type,
        shift: $('#shift').val(),
        client: $('#client').val(),
        department_id: $('#dept').val(),
        sub_department_id: $('#sub_dept').val(),
//        department_id: $('#dept').val(),
        supervisor_id: $('#supervisor_id').val(),
//        from_view_team_page: 'true'
      },
      async: false,
      success: function (response) {

        $('.added_employees_table_div').html(response);
        stop_loader();
      },
      error: function () {

        //alert('Something went wrong! Please try again later.');
        stop_loader();
      }
    });
  }

}

function get_employees_to_be_added_table_markup() {

//start_loader();

  $.ajax({

    type: 'POST',
    async: false,
    //url: baseURL + 'get_employees_to_be_added_table_markup',
    url: baseURL + 'getEmployeesToBeAddedTableMarkup',
    data: {
      shift: $('#shift').val(),
      department_id: $('#department_id').val(),
      supervisor_id: $('#supervisor_id').val(),
      employee_name_id_filter: $('#employee_name_id_filter').val(),
      employee_code_filter: $('#employee_code_filter').val(),
      employee_email_filter: $('#employee_email_filter').val(),
      employee_department_filter: $('#employee_department_filter').val(),
      team_submitted: $('#team_submitted').val()
    },
    async: false,
    success: function (response) {

      $('#employees_to_add_table_div').html(response);
      setTimeout(function () {

        stop_loader();
      }, 1000);
    },
    error: function () {

      //alert('Something went wrong! Please try again later.');
    }
  });
}

function start_loader() {

  $('body').css('opacity', '0.5');
  $('body').css('pointer-events', 'none');
}

function stop_loader() {

  $('body').css('opacity', '1');
  $('body').css('pointer-events', '');
}

function remove_employee_from_team(employee_id, client_id, dept_id, sub_dept_id, shift) {
  start_loader();
  $.ajax({
    type: 'POST',
    async: false,
    //url: baseURL + '/remove_employee_from_team',
    url: baseURL + '/removeEmployeeFromTeam',
    dataType: 'JSON',
    data: {

      employee_id: employee_id,
      client_id: client_id,
      dept_id: dept_id,
      sub_dept_id: sub_dept_id,
      shift: shift,
//      current_satus: $('#' + employee_id).val(),
      team_id: $('#team_id').val()
    },
    async: false,
    success: function (response) {

      if (response == 'success') {
        setTimeout(function () {

          get_added_employees_table_markup('filter');
          get_employees_to_be_added_table_markup();
          stop_loader();
        }, 1000);
      } else {
        alert('You do not have permission');
        stop_loader();
      }

    },
    error: function () {

      //alert('Something went wrong! Please try again later.');
    }
  });
}

function leave_employee_from_team(employee_id, client_id, dept_id, sub_dept_id, shift) {
  start_loader();
  $.ajax({
    type: 'POST',
    async: false,
    //url: baseURL + '/remove_employee_from_team',
    url: baseURL + '/leaveEmployeeFromTeam',
    dataType: 'JSON',
    data: {

      employee_id: employee_id,
      client_id: client_id,
      dept_id: dept_id,
      sub_dept_id: sub_dept_id,
      shift: shift,
      current_satus: $('#' + employee_id).val(),
    },
    async: false,
    success: function (response) {

      if (response == 'success') {
        setTimeout(function () {

          get_added_employees_table_markup('filter');
          get_employees_to_be_added_table_markup();
          stop_loader();
        }, 1000);
      } else {
        alert('You do not have permission');
        stop_loader();
      }

    },
    error: function () {

      //alert('Something went wrong! Please try again later.');
    }
  });
}

function add_employee_to_team(employee_id) {

  start_loader();
  $.ajax({

    type: 'POST',
    async: false,
    //url: baseURL + '/add_employee_to_team',
    url: baseURL + '/addEmployeeToTeam',
    data: {

      employee_id: employee_id,
      team_id: $('#team_id').val(),
      client_id: $('#client').val(),
      dept_id: $('#dept').val(),
      sub_dept_id: $('#sub_dept').val(),
      shift_id: $('#shift').val(),
    },
    async: false,
    success: function (response) {

      get_added_employees_table_markup('filter');
      get_employees_to_be_added_table_markup();
      setTimeout(function () {

        stop_loader();
        $('#alert_message_div').html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success!</strong> Employee added successfully.</div>');
      }, 1000);
    },
    error: function () {

      //alert('Something went wrong! Please try again later.');
    }
  });
}

function add_employees_to_team() {

  let  favorite = [];
  $.each($("input[name='employees_to_add[]']:checked"), function () {
    favorite.push($(this).val());
  });
  //alert(favorite);

  //console.log(favorite);

  start_loader();
  $.ajax({

    type: 'POST',
    async: false,
    //url: baseURL + '/add_employee_to_team',
    url: baseURL + '/addEmployeeToTeamm',
    data: {
      team_id: $('#team_id').val(),
      client_id: $('#client').val(),
      dept_id: $('#dept').val(),
      sub_dept_id: $('#sub_dept').val(),
      shift_id: $('#shift').val(),
      alluserids: favorite
    },
    async: false,
    success: function (response) {

      get_added_employees_table_markup('filter');
      get_employees_to_be_added_table_markup();
      setTimeout(function () {

        stop_loader();
        $('#alert_message_div').html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success!</strong> Employee added successfully.</div>');
      }, 1000);
    },
    error: function () {

      //alert('Something went wrong! Please try again later.');
    }
  });
}

function selectAllEmp() {
  if ($(".select_all").prop('checked') === true) {
    $('.employees_to_add').attr('checked', true);
  } else {
    $('.employees_to_add').attr('checked', false);
  }

}
